/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.classlayout.UtilityClassWithoutPrivateConstructorInspectionBase;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilityClassWithoutPrivateConstructorInspection
extends UtilityClassWithoutPrivateConstructorInspectionBase {
    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel annotationsPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
        panel2.add((Component)annotationsPanel, "Center");
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("utility.class.without.private.constructor.option", new Object[0]), (InspectionProfileEntry)this, "ignoreClassesWithOnlyMain");
        panel2.add((Component)checkBox, "South");
        return panel2;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        PsiClass aClass = (PsiClass)infos[0];
        PsiMethod constructor = UtilityClassWithoutPrivateConstructorInspection.getNullArgConstructor(aClass);
        if (constructor == null) {
            fixes.add(new CreateEmptyPrivateConstructor());
        } else {
            Query query = ReferencesSearch.search((PsiElement)constructor, (SearchScope)constructor.getUseScope());
            PsiReference reference = (PsiReference)query.findFirst();
            if (reference == null) {
                fixes.add(new MakeConstructorPrivateFix());
            }
        }
        AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)aClass, (List<String>)((Object)this.ignorableAnnotations), fixes);
        return fixes.toArray(new InspectionGadgetsFix[fixes.size()]);
    }

    private static class MakeConstructorPrivateFix
    extends InspectionGadgetsFix {
        private MakeConstructorPrivateFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("utility.class.without.private.constructor.make.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethod[] constructors;
            PsiElement classNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = classNameIdentifier.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                PsiParameterList parameterList = constructor.getParameterList();
                if (parameterList.getParametersCount() != 0) continue;
                PsiModifierList modifiers = constructor.getModifierList();
                modifiers.setModifierProperty("public", false);
                modifiers.setModifierProperty("protected", false);
                modifiers.setModifierProperty("private", true);
            }
        }
    }

    protected static class CreateEmptyPrivateConstructor
    extends InspectionGadgetsFix {
        protected CreateEmptyPrivateConstructor() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("utility.class.without.private.constructor.create.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement classNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = classNameIdentifier.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            Query query = ReferencesSearch.search((PsiElement)aClass, (SearchScope)aClass.getUseScope());
            for (PsiReference reference : query) {
                PsiElement element;
                PsiElement context;
                if (reference == null || !((context = (element = reference.getElement()).getParent()) instanceof PsiNewExpression)) continue;
                SwingUtilities.invokeLater(() -> Messages.showInfoMessage((Project)aClass.getProject(), (String)"Utility class has instantiations, private constructor will not be created", (String)"Can't generate constructor"));
                return;
            }
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiMethod constructor = factory.createConstructor();
            PsiModifierList modifierList = constructor.getModifierList();
            modifierList.setModifierProperty("private", true);
            aClass.add((PsiElement)constructor);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project2);
            styleManager.reformat((PsiElement)constructor);
        }
    }
}

