/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import org.jetbrains.annotations.NotNull;

public class AnonymousClassMethodCountInspectionBase
extends ClassMetricInspection {
    private static final int DEFAULT_METHOD_COUNT_LIMIT = 1;

    @NotNull
    public String getID() {
        return "AnonymousInnerClassWithTooManyMethods";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("anonymous.inner.class.with.too.many.methods.display.name", new Object[0]);
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.count.limit.option", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        return InspectionGadgetsBundle.message("anonymous.inner.class.with.too.many.methods.problem.descriptor", count);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AnonymousClassMethodCountVisitor();
    }

    private class AnonymousClassMethodCountVisitor
    extends BaseInspectionVisitor {
        private AnonymousClassMethodCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass psiClass) {
        }

        public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
            if (aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            int totalMethodCount = this.calculateTotalMethodCount((PsiClass)aClass);
            if (totalMethodCount <= AnonymousClassMethodCountInspectionBase.this.getLimit()) {
                return;
            }
            this.registerClassError((PsiClass)aClass, totalMethodCount);
        }

        private int calculateTotalMethodCount(PsiClass aClass) {
            return aClass.getMethods().length - aClass.getConstructors().length;
        }
    }
}

