/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneDeclaresCloneNotSupportedInspection
extends BaseInspection {
    public boolean onlyWarnOnProtectedClone = true;

    @NotNull
    public String getID() {
        return "CloneDoesntDeclareCloneNotSupportedException";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("only.warn.on.protected.clone.methods", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnProtectedClone");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.writeBooleanOption(node, "onlyWarnOnProtectedClone", true);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CloneDeclaresCloneNotSupportedInspectionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneDeclaresCloneNotSupportedExceptionVisitor();
    }

    private class CloneDeclaresCloneNotSupportedExceptionVisitor
    extends BaseInspectionVisitor {
        private CloneDeclaresCloneNotSupportedExceptionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            super.visitMethod(method2);
            if (!CloneUtils.isClone(method2)) {
                return;
            }
            if (method2.hasModifierProperty("final")) {
                return;
            }
            if (CloneDeclaresCloneNotSupportedInspection.this.onlyWarnOnProtectedClone && method2.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("final")) {
                return;
            }
            if (MethodUtils.hasInThrows(method2, "java.lang.CloneNotSupportedException")) {
                return;
            }
            PsiMethod superMethod = MethodUtils.getSuper(method2);
            if (superMethod != null && !MethodUtils.hasInThrows(superMethod, "java.lang.CloneNotSupportedException")) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }

    private static class CloneDeclaresCloneNotSupportedInspectionFix
    extends InspectionGadgetsFix {
        private CloneDeclaresCloneNotSupportedInspectionFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.declare.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiMethod method2 = (PsiMethod)methodNameIdentifier.getParent();
            PsiUtil.addException((PsiMethod)method2, (String)"java.lang.CloneNotSupportedException");
        }
    }
}

