/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalExpressionWithIdenticalBranchesInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean myReportOnlyExactlyIdentical;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report only exactly identical branches", (InspectionProfileEntry)this, "myReportOnlyExactlyIdentical");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        EquivalenceChecker.Decision decision = (EquivalenceChecker.Decision)infos[1];
        return InspectionGadgetsBundle.message(decision.isExact() ? "conditional.expression.with.identical.branches.problem.descriptor" : "conditional.expression.with.similar.branches.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseConditional((PsiConditionalExpression)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionWithIdenticalBranchesVisitor();
    }

    private class ConditionalExpressionWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionWithIdenticalBranchesVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression thenExpression2 = expression2.getThenExpression();
            PsiExpression elseExpression2 = expression2.getElseExpression();
            EquivalenceChecker.Decision decision = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalentDecision(thenExpression2, elseExpression2);
            if (thenExpression2 != null && (ConditionalExpressionWithIdenticalBranchesInspection.this.myReportOnlyExactlyIdentical ? decision.getExactlyMatches() : !decision.isExactUnMatches())) {
                this.registerError((PsiElement)expression2, expression2, decision);
            }
        }
    }

    private static class CollapseConditional
    extends InspectionGadgetsFix {
        private final SmartPsiElementPointer<PsiConditionalExpression> myConditionalExpression;

        public CollapseConditional(PsiConditionalExpression expression2) {
            this.myConditionalExpression = SmartPointerManager.getInstance((Project)expression2.getProject()).createSmartPsiElementPointer((PsiElement)expression2);
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message(this.getEquivalenceDecision().getExactlyMatches() ? "conditional.expression.with.identical.branches.collapse.quickfix" : "conditional.expression.with.identical.branches.push.inside.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.collapse.quickfix.family", new Object[0]);
        }

        public PsiConditionalExpression getConditionalExpression() {
            return (PsiConditionalExpression)this.myConditionalExpression.getElement();
        }

        private EquivalenceChecker.Decision getEquivalenceDecision() {
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalentDecision(this.getConditionalExpression().getThenExpression(), this.getConditionalExpression().getElseExpression());
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            EquivalenceChecker.Decision decision = this.getEquivalenceDecision();
            PsiConditionalExpression conditionalExpression = this.getConditionalExpression();
            PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
            assert (thenExpression2 != null);
            if (decision.getExactlyMatches()) {
                PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor.getPsiElement();
                String bodyText = thenExpression2.getText();
                PsiReplacementUtil.replaceExpression((PsiExpression)expression2, bodyText);
            } else if (!decision.isExactUnMatches()) {
                PsiElement leftDiff = decision.getLeftDiff();
                PsiElement rightDiff = decision.getRightDiff();
                String expression3 = "(" + conditionalExpression.getCondition().getText() + " ? " + leftDiff.getText() + " : " + rightDiff.getText() + ")";
                PsiExpression newConditionalExpression = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(expression3, (PsiElement)conditionalExpression);
                PsiElement replacedConditionalExpression = leftDiff.replace((PsiElement)newConditionalExpression);
                ParenthesesUtils.removeParentheses((PsiExpression)replacedConditionalExpression, false);
                conditionalExpression.replace((PsiElement)thenExpression2);
            }
        }
    }
}

