/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class DefaultNotLastCaseInSwitchInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("default.not.last.case.in.switch.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("default.not.last.case.in.switch.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DefaultNotLastCaseInSwitchVisitor();
    }

    private static class DefaultNotLastCaseInSwitchVisitor
    extends BaseInspectionVisitor {
        private DefaultNotLastCaseInSwitchVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
            super.visitSwitchStatement(statement2);
            PsiCodeBlock body2 = statement2.getBody();
            if (body2 == null) {
                return;
            }
            PsiStatement[] statements = body2.getStatements();
            boolean labelSeen = false;
            for (int i2 = statements.length - 1; i2 >= 0; --i2) {
                PsiStatement child = statements[i2];
                if (!(child instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)child;
                if (label.isDefaultCase()) {
                    if (labelSeen) {
                        this.registerStatementError((PsiStatement)label, new Object[0]);
                    }
                    return;
                }
                labelSeen = true;
            }
        }
    }
}

