/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateConditionInspection
extends BaseInspection {
    public boolean ignoreMethodCalls = false;
    private static final int LIMIT_DEPTH = 20;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("duplicate.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("duplicate.condition.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("duplicate.condition.ignore.method.calls.option", new Object[0]), (InspectionProfileEntry)this, "ignoreMethodCalls");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DuplicateConditionVisitor();
    }

    private class DuplicateConditionVisitor
    extends BaseInspectionVisitor {
        private DuplicateConditionVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement2) {
            super.visitIfStatement(statement2);
            if (ControlFlowUtils.isElseIf(statement2)) {
                return;
            }
            HashSet<PsiExpression> conditions = new HashSet<PsiExpression>();
            this.collectConditionsForIfStatement(statement2, conditions, 0);
            int numConditions = conditions.size();
            if (numConditions < 2) {
                return;
            }
            PsiExpression[] conditionArray = conditions.toArray(new PsiExpression[numConditions]);
            boolean[] matched = new boolean[conditionArray.length];
            Arrays.fill(matched, false);
            for (int i2 = 0; i2 < conditionArray.length; ++i2) {
                if (matched[i2]) continue;
                PsiExpression condition2 = conditionArray[i2];
                for (int j = i2 + 1; j < conditionArray.length; ++j) {
                    if (matched[j]) continue;
                    PsiExpression testCondition = conditionArray[j];
                    boolean areEquivalent = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(condition2, testCondition);
                    if (!areEquivalent) continue;
                    if (!DuplicateConditionInspection.this.ignoreMethodCalls || !this.containsMethodCallExpression((PsiElement)testCondition)) {
                        this.registerError((PsiElement)testCondition, new Object[0]);
                        if (!matched[i2]) {
                            this.registerError((PsiElement)condition2, new Object[0]);
                        }
                    }
                    matched[i2] = true;
                    matched[j] = true;
                }
            }
        }

        private void collectConditionsForIfStatement(PsiIfStatement statement2, Set<PsiExpression> conditions, int depth) {
            if (depth > 20) {
                return;
            }
            PsiExpression condition2 = statement2.getCondition();
            this.collectConditionsForExpression(condition2, conditions);
            PsiStatement branch = statement2.getElseBranch();
            if (branch instanceof PsiIfStatement) {
                this.collectConditionsForIfStatement((PsiIfStatement)branch, conditions, depth + 1);
            }
        }

        private void collectConditionsForExpression(PsiExpression condition2, Set<PsiExpression> conditions) {
            PsiPolyadicExpression polyadicExpression;
            IElementType tokenType;
            if (condition2 == null) {
                return;
            }
            if (condition2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition2;
                PsiExpression contents = parenthesizedExpression.getExpression();
                this.collectConditionsForExpression(contents, conditions);
                return;
            }
            if (condition2 instanceof PsiPolyadicExpression && JavaTokenType.OROR.equals(tokenType = (polyadicExpression = (PsiPolyadicExpression)condition2).getOperationTokenType())) {
                PsiExpression[] operands2;
                for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                    this.collectConditionsForExpression(operand2, conditions);
                }
                return;
            }
            conditions.add(condition2);
        }

        private boolean containsMethodCallExpression(PsiElement element) {
            PsiElement[] children2;
            if (element instanceof PsiMethodCallExpression) {
                return true;
            }
            for (PsiElement child : children2 = element.getChildren()) {
                if (!this.containsMethodCallExpression(child)) continue;
                return true;
            }
            return false;
        }
    }
}

