/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class IfStatementWithTooManyBranchesInspection
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 3;
    public int m_limit = 3;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("if.statement.with.too.many.branches.display.name", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("if.statement.with.too.many.branches.max.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        return InspectionGadgetsBundle.message("if.statement.with.too.many.branches.problem.descriptor", branchCount);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementWithTooManyBranchesVisitor();
    }

    private class IfStatementWithTooManyBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithTooManyBranchesVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement2) {
            super.visitIfStatement(statement2);
            if (ControlFlowUtils.isElseIf(statement2)) {
                return;
            }
            int branchCount = this.calculateBranchCount(statement2);
            if (branchCount <= IfStatementWithTooManyBranchesInspection.this.m_limit) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, branchCount);
        }

        private int calculateBranchCount(PsiIfStatement statement2) {
            PsiStatement branch = statement2.getElseBranch();
            if (branch == null) {
                return 1;
            }
            if (!(branch instanceof PsiIfStatement)) {
                return 2;
            }
            return 1 + this.calculateBranchCount((PsiIfStatement)branch);
        }
    }
}

