/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class InfiniteLoopStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("infinite.loop.statement.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("infinite.loop.statement.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InfiniteLoopStatementsVisitor();
    }

    private static class InfiniteLoopStatementsVisitor
    extends BaseInspectionVisitor {
        private InfiniteLoopStatementsVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            super.visitForStatement(statement2);
            this.checkStatement((PsiStatement)statement2);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            this.checkStatement((PsiStatement)statement2);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
            super.visitDoWhileStatement(statement2);
            this.checkStatement((PsiStatement)statement2);
        }

        private void checkStatement(PsiStatement statement2) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement2)) {
                return;
            }
            if (ControlFlowUtils.containsReturn((PsiElement)statement2)) {
                return;
            }
            if (ControlFlowUtils.containsSystemExit((PsiElement)statement2)) {
                return;
            }
            this.registerStatementError(statement2, new Object[0]);
        }
    }
}

