/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessBooleanExpressionInspection
extends BaseInspection {
    private static final Set<IElementType> booleanTokens = new HashSet<IElementType>();
    public boolean m_ignoreExpressionsContainingConstants = true;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("pointless.boolean.expression.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        return InspectionGadgetsBundle.message("boolean.expression.can.be.simplified.problem.descriptor", this.buildSimplifiedExpression(expression2, new StringBuilder()).toString());
    }

    private StringBuilder buildSimplifiedExpression(@Nullable PsiExpression expression2, StringBuilder out) {
        if (expression2 instanceof PsiPolyadicExpression) {
            this.buildSimplifiedPolyadicExpression((PsiPolyadicExpression)expression2, out);
        } else if (expression2 instanceof PsiPrefixExpression) {
            this.buildSimplifiedPrefixExpression((PsiPrefixExpression)expression2, out);
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression expression1 = parenthesizedExpression.getExpression();
            out.append('(');
            this.buildSimplifiedExpression(expression1, out);
            out.append(')');
        } else if (expression2 != null) {
            out.append(expression2.getText());
        }
        return out;
    }

    private void buildSimplifiedPolyadicExpression(PsiPolyadicExpression expression2, StringBuilder out) {
        IElementType tokenType = expression2.getOperationTokenType();
        PsiExpression[] operands2 = expression2.getOperands();
        ArrayList<PsiExpression> expressions2 = new ArrayList<PsiExpression>();
        if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.AND)) {
            for (PsiExpression operand2 : operands2) {
                if (this.evaluate(operand2) == Boolean.TRUE) continue;
                if (this.evaluate(operand2) == Boolean.FALSE) {
                    out.append("false");
                    return;
                }
                expressions2.add(operand2);
            }
            if (expressions2.isEmpty()) {
                out.append("true");
                return;
            }
            this.buildSimplifiedExpression(expressions2, tokenType.equals(JavaTokenType.ANDAND) ? "&&" : "&", false, out);
        } else if (tokenType.equals(JavaTokenType.OROR) || tokenType.equals(JavaTokenType.OR)) {
            for (PsiExpression operand3 : operands2) {
                if (this.evaluate(operand3) == Boolean.FALSE) continue;
                if (this.evaluate(operand3) == Boolean.TRUE) {
                    out.append("true");
                    return;
                }
                expressions2.add(operand3);
            }
            if (expressions2.isEmpty()) {
                out.append("false");
                return;
            }
            this.buildSimplifiedExpression(expressions2, tokenType.equals(JavaTokenType.OROR) ? "||" : "|", false, out);
        } else if (tokenType.equals(JavaTokenType.XOR) || tokenType.equals(JavaTokenType.NE)) {
            boolean negate = false;
            for (PsiExpression operand4 : operands2) {
                if (this.evaluate(operand4) == Boolean.FALSE) continue;
                if (this.evaluate(operand4) == Boolean.TRUE) {
                    negate = !negate;
                    continue;
                }
                expressions2.add(operand4);
            }
            if (expressions2.isEmpty()) {
                if (negate) {
                    out.append("true");
                } else {
                    out.append("false");
                }
                return;
            }
            this.buildSimplifiedExpression(expressions2, tokenType.equals(JavaTokenType.XOR) ? "^" : "!=", negate, out);
        } else if (tokenType.equals(JavaTokenType.EQEQ)) {
            boolean negate = false;
            for (PsiExpression operand5 : operands2) {
                if (this.evaluate(operand5) == Boolean.TRUE) continue;
                if (this.evaluate(operand5) == Boolean.FALSE) {
                    negate = !negate;
                    continue;
                }
                expressions2.add(operand5);
            }
            if (expressions2.isEmpty()) {
                if (negate) {
                    out.append("false");
                } else {
                    out.append("true");
                }
                return;
            }
            this.buildSimplifiedExpression(expressions2, "==", negate, out);
        } else {
            out.append(expression2.getText());
        }
    }

    private void buildSimplifiedExpression(List<PsiExpression> expressions2, String token, boolean negate, StringBuilder out) {
        if (expressions2.size() == 1) {
            PsiExpression expression2 = expressions2.get(0);
            if (!negate) {
                out.append(expression2.getText());
                return;
            }
            if (ComparisonUtils.isComparison(expression2)) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                String negatedComparison = ComparisonUtils.getNegatedComparison(binaryExpression.getOperationTokenType());
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                assert (rhs != null);
                out.append(lhs.getText()).append(negatedComparison).append(rhs.getText());
            } else if (ParenthesesUtils.getPrecedence(expression2) > 3) {
                out.append("!(").append(expression2.getText()).append(')');
            } else {
                out.append('!').append(expression2.getText());
            }
        } else {
            if (negate) {
                out.append("!(");
            }
            boolean useToken = false;
            for (PsiExpression expression3 : expressions2) {
                if (useToken) {
                    out.append(token);
                    PsiElement previousSibling = expression3.getPrevSibling();
                    if (previousSibling instanceof PsiWhiteSpace) {
                        out.append(previousSibling.getText());
                    }
                } else {
                    useToken = true;
                }
                this.buildSimplifiedExpression(expression3, out);
                PsiElement nextSibling = expression3.getNextSibling();
                if (!(nextSibling instanceof PsiWhiteSpace)) continue;
                out.append(nextSibling.getText());
            }
            if (negate) {
                out.append(')');
            }
        }
    }

    private void buildSimplifiedPrefixExpression(PsiPrefixExpression expression2, StringBuilder out) {
        PsiJavaToken sign = expression2.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        PsiExpression operand2 = expression2.getOperand();
        if (JavaTokenType.EXCL.equals(tokenType)) {
            Boolean value2 = this.evaluate(operand2);
            if (value2 == Boolean.TRUE) {
                out.append("false");
                return;
            }
            if (value2 == Boolean.FALSE) {
                out.append("true");
                return;
            }
        }
        this.buildSimplifiedExpression(operand2, out.append(sign.getText()));
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessBooleanExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBooleanExpressionVisitor();
    }

    @Nullable
    private Boolean evaluate(@Nullable PsiExpression expression2) {
        Boolean value2;
        PsiPrefixExpression prefixExpression;
        IElementType tokenType;
        if (expression2 == null || this.m_ignoreExpressionsContainingConstants && PointlessBooleanExpressionInspection.containsReference(expression2)) {
            return null;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            return this.evaluate(parenthesizedExpression.getExpression());
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            IElementType tokenType2 = polyadicExpression.getOperationTokenType();
            if (tokenType2.equals(JavaTokenType.OROR)) {
                PsiExpression[] operands2;
                for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                    if (this.evaluate(operand2) != Boolean.TRUE) continue;
                    return Boolean.TRUE;
                }
            } else if (tokenType2.equals(JavaTokenType.ANDAND)) {
                PsiExpression[] operands3;
                for (PsiExpression operand3 : operands3 = polyadicExpression.getOperands()) {
                    if (this.evaluate(operand3) != Boolean.FALSE) continue;
                    return Boolean.FALSE;
                }
            }
        } else if (expression2 instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals(tokenType = (prefixExpression = (PsiPrefixExpression)expression2).getOperationTokenType())) {
            PsiExpression operand4 = prefixExpression.getOperand();
            Boolean b = this.evaluate(operand4);
            if (b == Boolean.FALSE) {
                return Boolean.TRUE;
            }
            if (b == Boolean.TRUE) {
                return Boolean.FALSE;
            }
        }
        return (value2 = (Boolean)ConstantExpressionUtil.computeCastTo((PsiExpression)expression2, (PsiType)PsiType.BOOLEAN)) != null ? value2 : null;
    }

    private static boolean containsReference(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        ReferenceVisitor visitor = new ReferenceVisitor();
        expression2.accept((PsiElementVisitor)visitor);
        return visitor.containsReference();
    }

    static {
        booleanTokens.add(JavaTokenType.ANDAND);
        booleanTokens.add(JavaTokenType.AND);
        booleanTokens.add(JavaTokenType.OROR);
        booleanTokens.add(JavaTokenType.OR);
        booleanTokens.add(JavaTokenType.XOR);
        booleanTokens.add(JavaTokenType.EQEQ);
        booleanTokens.add(JavaTokenType.NE);
    }

    private static class ReferenceVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean referenceFound;

        private ReferenceVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (this.referenceFound) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiElement target = expression2.resolve();
            if (target instanceof PsiField && ExpressionUtils.isConstant((PsiField)target)) {
                this.referenceFound = true;
            } else {
                super.visitReferenceExpression(expression2);
            }
        }

        private boolean containsReference() {
            return this.referenceFound;
        }
    }

    private class PointlessBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private PointlessBooleanExpressionVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        private void checkExpression(PsiExpression expression2) {
            if (!this.isPointlessBooleanExpression(expression2)) {
                return;
            }
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
            if (parent instanceof PsiExpression && this.isPointlessBooleanExpression((PsiExpression)parent)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private boolean isPointlessBooleanExpression(PsiExpression expression2) {
            if (expression2 instanceof PsiPrefixExpression) {
                return PointlessBooleanExpressionInspection.this.evaluate(expression2) != null;
            }
            if (expression2 instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                IElementType sign = polyadicExpression.getOperationTokenType();
                if (!booleanTokens.contains(sign)) {
                    return false;
                }
                PsiExpression[] operands2 = polyadicExpression.getOperands();
                boolean containsConstant = false;
                for (PsiExpression operand2 : operands2) {
                    if (operand2 == null) {
                        return false;
                    }
                    PsiType type2 = operand2.getType();
                    if (type2 == null || !type2.equals(PsiType.BOOLEAN) && !type2.equalsToText("java.lang.Boolean")) {
                        return false;
                    }
                    containsConstant |= PointlessBooleanExpressionInspection.this.evaluate(operand2) != null;
                }
                return containsConstant;
            }
            return false;
        }
    }

    private class PointlessBooleanExpressionFix
    extends InspectionGadgetsFix {
        private PointlessBooleanExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression2 = (PsiExpression)element;
            PsiReplacementUtil.replaceExpression(expression2, PointlessBooleanExpressionInspection.this.buildSimplifiedExpression(expression2, new StringBuilder()).toString());
        }
    }
}

