/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableBooleanExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("simplifiable.boolean.expression.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object info = infos[0];
        if (info instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)info;
            return InspectionGadgetsBundle.message("boolean.expression.can.be.simplified.problem.descriptor", SimplifiableBooleanExpressionInspection.calculateReplacementExpression(prefixExpression));
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)info;
        return InspectionGadgetsBundle.message("boolean.expression.can.be.simplified.problem.descriptor", SimplifiableBooleanExpressionInspection.calculateReplacementExpression(binaryExpression));
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableBooleanExpressionFix();
    }

    @NonNls
    static String calculateReplacementExpression(PsiPrefixExpression expression2) {
        PsiExpression operand2 = ParenthesesUtils.stripParentheses(expression2.getOperand());
        if (!(operand2 instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand2;
        PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
        PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
        if (lhs == null || rhs == null) {
            return null;
        }
        return ParenthesesUtils.getText(lhs, 9) + "==" + ParenthesesUtils.getText(rhs, 9);
    }

    @NonNls
    static String calculateReplacementExpression(PsiBinaryExpression expression2) {
        PsiExpression rhs1 = ParenthesesUtils.stripParentheses(expression2.getROperand());
        if (rhs1 == null) {
            return null;
        }
        PsiExpression lhs = ParenthesesUtils.stripParentheses(expression2.getLOperand());
        if (!(lhs instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)lhs;
        PsiExpression rhs2 = binaryExpression.getROperand();
        if (rhs2 == null) {
            return null;
        }
        return ParenthesesUtils.getText(rhs1, 14) + "||" + ParenthesesUtils.getText(rhs2, 14);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableBooleanExpressionVisitor();
    }

    private static class SimplifiableBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableBooleanExpressionVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!JavaTokenType.EXCL.equals(tokenType)) {
                return;
            }
            PsiExpression operand2 = ParenthesesUtils.stripParentheses(expression2.getOperand());
            if (!(operand2 instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand2;
            IElementType binaryTokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.XOR.equals(binaryTokenType)) {
                return;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            if (lhs == null || rhs == null) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            IElementType tokenType1 = expression2.getOperationTokenType();
            if (!JavaTokenType.OROR.equals(tokenType1)) {
                return;
            }
            PsiExpression lhs1 = ParenthesesUtils.stripParentheses(expression2.getLOperand());
            if (!(lhs1 instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)lhs1;
            IElementType tokenType2 = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.ANDAND.equals(tokenType2)) {
                return;
            }
            PsiExpression lhs2 = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rhs1 = ParenthesesUtils.stripParentheses(expression2.getROperand());
            PsiExpression negated = BoolUtils.getNegated(rhs1);
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(lhs2, negated)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }
    }

    private static class SimplifiableBooleanExpressionFix
    extends InspectionGadgetsFix {
        private SimplifiableBooleanExpressionFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            String replacement;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
                replacement = SimplifiableBooleanExpressionInspection.calculateReplacementExpression(prefixExpression);
            } else if (element instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
                replacement = SimplifiableBooleanExpressionInspection.calculateReplacementExpression(binaryExpression);
            } else {
                return;
            }
            if (replacement == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)element, replacement);
        }
    }
}

