/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimplifiableConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("simplifiable.conditional.expression.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiConditionalExpression expression2 = (PsiConditionalExpression)infos[0];
        return InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", SimplifiableConditionalExpressionInspection.calculateReplacementExpression(expression2));
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableConditionalExpressionVisitor();
    }

    @NonNls
    static String calculateReplacementExpression(PsiConditionalExpression expression2) {
        PsiExpression thenExpression2 = expression2.getThenExpression();
        PsiExpression elseExpression2 = expression2.getElseExpression();
        PsiExpression condition2 = expression2.getCondition();
        assert (thenExpression2 != null);
        assert (elseExpression2 != null);
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(BoolUtils.getNegated(thenExpression2), elseExpression2)) {
            return ParenthesesUtils.getText(condition2, 9) + " != " + BoolUtils.getNegatedExpressionText(thenExpression2, 9);
        }
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression2, BoolUtils.getNegated(elseExpression2))) {
            return ParenthesesUtils.getText(condition2, 9) + " == " + ParenthesesUtils.getText(thenExpression2, 9);
        }
        if (BoolUtils.isTrue(thenExpression2)) {
            String elseExpressionText = ParenthesesUtils.getText(elseExpression2, 14);
            return ParenthesesUtils.getText(condition2, 14) + " || " + elseExpressionText;
        }
        if (BoolUtils.isFalse(thenExpression2)) {
            String elseExpressionText = ParenthesesUtils.getText(elseExpression2, 13);
            return BoolUtils.getNegatedExpressionText(condition2, 13) + " && " + elseExpressionText;
        }
        if (BoolUtils.isFalse(elseExpression2)) {
            String thenExpressionText = ParenthesesUtils.getText(thenExpression2, 13);
            return ParenthesesUtils.getText(condition2, 13) + " && " + thenExpressionText;
        }
        String thenExpressionText = ParenthesesUtils.getText(thenExpression2, 14);
        return BoolUtils.getNegatedExpressionText(condition2, 14) + " || " + thenExpressionText;
    }

    private static class SimplifiableConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            boolean elseConstant;
            super.visitConditionalExpression(expression2);
            PsiExpression thenExpression2 = expression2.getThenExpression();
            if (thenExpression2 == null) {
                return;
            }
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (elseExpression2 == null) {
                return;
            }
            PsiType thenType = thenExpression2.getType();
            if (!PsiType.BOOLEAN.equals((Object)thenType)) {
                return;
            }
            PsiType elseType = elseExpression2.getType();
            if (!PsiType.BOOLEAN.equals((Object)elseType)) {
                return;
            }
            boolean thenConstant = BoolUtils.isFalse(thenExpression2) || BoolUtils.isTrue(thenExpression2);
            boolean bl = elseConstant = BoolUtils.isFalse(elseExpression2) || BoolUtils.isTrue(elseExpression2);
            if (thenConstant == elseConstant) {
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(BoolUtils.getNegated(thenExpression2), elseExpression2) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression2, BoolUtils.getNegated(elseExpression2))) {
                    this.registerError((PsiElement)expression2, expression2);
                }
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }
    }

    private static class SimplifiableConditionalFix
    extends InspectionGadgetsFix {
        private SimplifiableConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor.getPsiElement();
            String newExpression = SimplifiableConditionalExpressionInspection.calculateReplacementExpression(expression2);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression);
        }
    }
}

