/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLabelOnBreakStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.label.on.break.statement.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.label.on.break.statement.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryLabelOnBreakStatementFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLabelOnBreakStatementVisitor();
    }

    private static class UnnecessaryLabelOnBreakStatementVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLabelOnBreakStatementVisitor() {
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement2) {
            PsiIdentifier labelIdentifier = statement2.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            String labelText = labelIdentifier.getText();
            if (labelText == null || labelText.length() == 0) {
                return;
            }
            PsiStatement exitedStatement = statement2.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            PsiStatement labelEnabledParent = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiForStatement.class, PsiDoWhileStatement.class, PsiForeachStatement.class, PsiWhileStatement.class, PsiSwitchStatement.class});
            if (labelEnabledParent == null) {
                return;
            }
            if (exitedStatement.equals(labelEnabledParent)) {
                this.registerStatementError((PsiStatement)statement2, new Object[0]);
            }
        }
    }

    private static class UnnecessaryLabelOnBreakStatementFix
    extends InspectionGadgetsFix {
        private UnnecessaryLabelOnBreakStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.label.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement breakKeywordElement = descriptor.getPsiElement();
            PsiBreakStatement breakStatement = (PsiBreakStatement)breakKeywordElement.getParent();
            PsiIdentifier identifier = breakStatement.getLabelIdentifier();
            if (identifier == null) {
                return;
            }
            identifier.delete();
        }
    }
}

