/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLabelOnContinueStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.label.on.continue.statement.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.label.on.continue.statement.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryLabelOnContinueStatementFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLabelOnContinueStatementVisitor();
    }

    private static class UnnecessaryLabelOnContinueStatementVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLabelOnContinueStatementVisitor() {
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement2) {
            PsiIdentifier labelIdentifier = statement2.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            String labelText = labelIdentifier.getText();
            if (labelText == null || labelText.length() == 0) {
                return;
            }
            PsiStatement exitedStatement = statement2.findContinuedStatement();
            if (exitedStatement == null) {
                return;
            }
            PsiStatement labelEnabledParent = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiForStatement.class, PsiDoWhileStatement.class, PsiForeachStatement.class, PsiWhileStatement.class, PsiSwitchStatement.class});
            if (labelEnabledParent == null) {
                return;
            }
            if (!exitedStatement.equals(labelEnabledParent)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }
    }

    private static class UnnecessaryLabelOnContinueStatementFix
    extends InspectionGadgetsFix {
        private UnnecessaryLabelOnContinueStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.label.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement continueKeywordElement = descriptor.getPsiElement();
            PsiContinueStatement continueStatement = (PsiContinueStatement)continueKeywordElement.getParent();
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            labelIdentifier.delete();
        }
    }
}

