/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScopeUtils {
    private ScopeUtils() {
    }

    @Nullable
    public static PsiElement findTighterDeclarationLocation(@NotNull PsiElement sibling, @NotNull PsiVariable variable) {
        PsiElement prevSibling = sibling.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof PsiComment) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof PsiDeclarationStatement) {
            if (prevSibling.equals(variable.getParent())) {
                return null;
            }
            return ScopeUtils.findTighterDeclarationLocation(prevSibling, variable);
        }
        return prevSibling;
    }

    @Nullable
    public static PsiElement getChildWhichContainsElement(@NotNull PsiElement ancestor, @NotNull PsiElement element) {
        PsiElement child = element;
        PsiElement parent = child.getParent();
        while (!parent.equals(ancestor)) {
            child = parent;
            if ((parent = child.getParent()) != null) continue;
            return null;
        }
        return child;
    }

    @Nullable
    public static PsiElement getCommonParent(@NotNull PsiElement[] referenceElements) {
        PsiElement parent;
        Arrays.sort(referenceElements, PsiElementOrderComparator.getInstance());
        PsiElement commonParent = null;
        for (PsiElement referenceElement : referenceElements) {
            PsiElement parent2 = PsiTreeUtil.getParentOfType((PsiElement)referenceElement, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class});
            if (parent2 != null && commonParent != null) {
                if (commonParent.equals(parent2)) continue;
                commonParent = PsiTreeUtil.findCommonParent((PsiElement)commonParent, (PsiElement)parent2);
                commonParent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)commonParent, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class});
                continue;
            }
            commonParent = parent2;
        }
        if (commonParent instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)commonParent;
            PsiElement referenceElement = referenceElements[0];
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiEmptyStatement)) {
                if (initialization instanceof PsiExpressionStatement) {
                    PsiExpressionStatement statement2 = (PsiExpressionStatement)initialization;
                    PsiExpression expression2 = statement2.getExpression();
                    if (expression2 instanceof PsiAssignmentExpression) {
                        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                        PsiExpression lExpression = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
                        if (!lExpression.equals(referenceElement)) {
                            commonParent = PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class);
                        }
                    } else {
                        commonParent = PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class);
                    }
                } else {
                    commonParent = PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class);
                }
            }
        }
        if (commonParent != null && (parent = commonParent.getParent()) instanceof PsiSwitchStatement) {
            if (referenceElements.length > 1) {
                commonParent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class, (boolean)false);
            } else if (PsiTreeUtil.getParentOfType((PsiElement)referenceElements[0], PsiSwitchLabelStatement.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class}) != null) {
                commonParent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class, (boolean)false);
            }
        }
        return commonParent;
    }

    @Nullable
    public static PsiElement moveOutOfLoopsAndClasses(@NotNull PsiElement scope, @NotNull PsiElement maxScope) {
        PsiElement result2 = maxScope;
        if (result2 instanceof PsiLoopStatement) {
            return result2;
        }
        while (!result2.equals(scope)) {
            PsiForStatement forStatement;
            PsiElement element = ScopeUtils.getChildWhichContainsElement(result2, scope);
            if (element instanceof PsiForStatement && (forStatement = (PsiForStatement)element).getInitialization() instanceof PsiEmptyStatement) {
                return element;
            }
            if (element == null || element instanceof PsiLoopStatement || element instanceof PsiClass || element instanceof PsiLambdaExpression) {
                while (result2 != null && !(result2 instanceof PsiCodeBlock)) {
                    result2 = result2.getParent();
                }
                return result2;
            }
            result2 = element;
        }
        return scope;
    }
}

