/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.util.RefEntityAlphabeticalComparator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyclicClassDependencyInspection
extends BaseGlobalInspection {
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("cyclic.class.dependency.display.name", new Object[0]);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        String errorString;
        RefClass[] classes2;
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        if (refClass.isAnonymous() || refClass.isLocalClass() || refClass.isSyntheticJSP()) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateTransitiveDependenciesForClass(refClass);
        Set<RefClass> dependents = DependencyUtils.calculateTransitiveDependentsForClass(refClass);
        HashSet<RefClass> mutualDependents = new HashSet<RefClass>(dependencies);
        mutualDependents.retainAll(dependents);
        int numMutualDependents = mutualDependents.size();
        if (numMutualDependents == 0) {
            return null;
        }
        if (numMutualDependents == 1) {
            classes2 = mutualDependents.toArray(new RefClass[1]);
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.1.problem.descriptor", refEntity.getName(), classes2[0].getExternalName());
        } else if (numMutualDependents == 2) {
            classes2 = mutualDependents.toArray(new RefClass[2]);
            Arrays.sort(classes2, RefEntityAlphabeticalComparator.getInstance());
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.2.problem.descriptor", refEntity.getName(), classes2[0].getExternalName(), classes2[1].getExternalName());
        } else {
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.problem.descriptor", refEntity.getName(), numMutualDependents);
        }
        PsiClass aClass = refClass.getElement();
        if (aClass == null) {
            return null;
        }
        PsiIdentifier anchor = aClass.getNameIdentifier();
        if (anchor == null) {
            return null;
        }
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor((PsiElement)anchor, errorString, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
    }
}

