/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.InitializationDependencyUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyclicClassInitializationInspection
extends BaseGlobalInspection {
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("cyclic.class.initialization.display.name", new Object[0]);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        PsiClass aClass = refClass.getElement();
        if (aClass.getContainingClass() != null) {
            return null;
        }
        Set<RefClass> dependencies = InitializationDependencyUtils.calculateTransitiveInitializationDependentsForClass(refClass);
        Set<RefClass> dependents = InitializationDependencyUtils.calculateTransitiveInitializationDependenciesForClass(refClass);
        HashSet<RefClass> mutualDependents = new HashSet<RefClass>(dependencies);
        mutualDependents.retainAll(dependents);
        int numMutualDependents = mutualDependents.size();
        if (numMutualDependents == 0) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("cyclic.class.initialization.problem.descriptor", refEntity.getName(), numMutualDependents);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }
}

