/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageVisibleInnerClassInspectionBase
extends BaseInspection {
    public boolean ignoreEnums = false;
    public boolean ignoreInterfaces = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("package.visible.inner.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("package.visible.inner.class.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("package.visible.inner.class.ignore.enum.option", new Object[0]), "ignoreEnums");
        panel2.addCheckbox(InspectionGadgetsBundle.message("package.visible.inner.class.ignore.interface.option", new Object[0]), "ignoreInterfaces");
        return panel2;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageVisibleInnerClassVisitor();
    }

    private class PackageVisibleInnerClassVisitor
    extends BaseInspectionVisitor {
        private PackageVisibleInnerClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.hasModifierProperty("public") || aClass.hasModifierProperty("protected") || aClass.hasModifierProperty("private")) {
                return;
            }
            if (!ClassUtils.isInnerClass(aClass)) {
                return;
            }
            if (PackageVisibleInnerClassInspectionBase.this.ignoreEnums && aClass.isEnum()) {
                return;
            }
            if (PackageVisibleInnerClassInspectionBase.this.ignoreInterfaces && aClass.isInterface()) {
                return;
            }
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

