/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ProtectedFieldInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("protected.field.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("protected.field.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProtectedFieldVisitor();
    }

    private static class ProtectedFieldVisitor
    extends BaseInspectionVisitor {
        private ProtectedFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (!field.hasModifierProperty("protected")) {
                return;
            }
            if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                return;
            }
            this.registerFieldError(field, field);
        }
    }
}

