/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.equality;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualityOperatorComparesObjectsInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("equality.operator.compares.objects.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("equality.operator.compares.objects.descriptor", infos);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualityVisitor();
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        return new InspectionGadgetsFix[]{new EqualsFix(infos), new SafeEqualsFix(infos)};
    }

    private static void doFixImpl(@NotNull PsiElement element) {
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        PsiExpression lhs = exp.getLOperand();
        PsiExpression rhs = exp.getROperand();
        if (rhs == null) {
            return;
        }
        PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
        if (strippedLhs == null) {
            return;
        }
        PsiExpression strippedRhs = ParenthesesUtils.stripParentheses(rhs);
        if (strippedRhs == null) {
            return;
        }
        String lhText = strippedLhs.getText();
        String rhText = strippedRhs.getText();
        String prefix = exp.getOperationTokenType().equals(JavaTokenType.EQEQ) ? "" : "!";
        String expString = ParenthesesUtils.getPrecedence(strippedLhs) > 1 ? prefix + '(' + lhText + ").equals(" + rhText + ')' : prefix + lhText + ".equals(" + rhText + ')';
        PsiReplacementUtil.replaceExpression((PsiExpression)exp, expString);
    }

    private static void doSafeFixImpl(PsiElement element) {
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        PsiExpression lhs = exp.getLOperand();
        PsiExpression rhs = exp.getROperand();
        if (rhs == null) {
            return;
        }
        PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
        if (strippedLhs == null) {
            return;
        }
        PsiExpression strippedRhs = ParenthesesUtils.stripParentheses(rhs);
        if (strippedRhs == null) {
            return;
        }
        String lhsText = strippedLhs.getText();
        String rhsText = strippedRhs.getText();
        PsiJavaToken operationSign = exp.getOperationSign();
        IElementType tokenType = operationSign.getTokenType();
        String signText = operationSign.getText();
        StringBuilder newExpression = new StringBuilder();
        if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)element) && ClassUtils.findClass("java.util.Objects", element) != null) {
            if (tokenType.equals(JavaTokenType.NE)) {
                newExpression.append('!');
            }
            newExpression.append("java.util.Objects.equals(").append(lhsText).append(',').append(rhsText).append(')');
        } else {
            newExpression.append(lhsText).append("==null?").append(rhsText).append(signText).append(" null:");
            if (tokenType.equals(JavaTokenType.NE)) {
                newExpression.append('!');
            }
            if (ParenthesesUtils.getPrecedence(strippedLhs) > 1) {
                newExpression.append('(').append(lhsText).append(')');
            } else {
                newExpression.append(lhsText);
            }
            newExpression.append(".equals(").append(rhsText).append(')');
        }
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)exp, newExpression.toString());
    }

    private static class ObjectEqualityVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualityVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            PsiClass containingClass;
            PsiMethod method2;
            super.visitBinaryExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.NE) && !tokenType.equals(JavaTokenType.EQEQ)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            PsiType lhsType = lhs.getType();
            if (lhsType == null || lhsType instanceof PsiPrimitiveType || TypeConversionUtil.isEnumType((PsiType)lhsType)) {
                return;
            }
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null || rhsType instanceof PsiPrimitiveType || TypeConversionUtil.isEnumType((PsiType)rhsType)) {
                return;
            }
            if ((lhs instanceof PsiThisExpression || rhs instanceof PsiThisExpression) && (method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class)) != null && "equals".equals(method2.getName()) && method2.getParameterList().getParametersCount() == 1 && (ObjectEqualityVisitor.isThisQualifier(lhs, containingClass = method2.getContainingClass()) || ObjectEqualityVisitor.isThisQualifier(rhs, containingClass))) {
                return;
            }
            String operationText = expression2.getOperationSign().getText();
            String prefix = tokenType.equals(JavaTokenType.NE) ? "!" : "";
            this.registerError((PsiElement)expression2, operationText, prefix);
        }

        private static boolean isThisQualifier(@Nullable PsiExpression expression2, @Nullable PsiClass psiClass) {
            if (expression2 instanceof PsiThisExpression) {
                PsiJavaCodeReferenceElement qualifier = ((PsiThisExpression)expression2).getQualifier();
                return qualifier == null || psiClass != null && qualifier.isReferenceTo((PsiElement)psiClass);
            }
            return false;
        }
    }

    private static class EqualsFix
    extends InspectionGadgetsFix {
        private final Object[] myInfos;

        public EqualsFix(Object ... infos) {
            this.myInfos = infos;
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("equality.operator.compares.objects.quickfix", this.myInfos);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("equality.operator.compares.objects.family.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            EqualityOperatorComparesObjectsInspection.doFixImpl(descriptor.getPsiElement());
        }
    }

    private static class SafeEqualsFix
    extends InspectionGadgetsFix {
        private final Object[] myInfos;

        public SafeEqualsFix(Object ... infos) {
            this.myInfos = infos;
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("equality.operator.compares.objects.safe.quickfix", this.myInfos);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("equality.operator.compares.objects.safe.family.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            EqualityOperatorComparesObjectsInspection.doSafeFixImpl(descriptor.getPsiElement());
        }
    }
}

