/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;

class CatchParameterUsedVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiParameter parameter;
    private boolean used;

    CatchParameterUsedVisitor(PsiParameter variable) {
        this.parameter = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (!this.used) {
            super.visitElement(element);
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
        if (this.used) {
            return;
        }
        super.visitReferenceExpression(reference);
        PsiElement element = reference.resolve();
        if (this.parameter.equals(element)) {
            this.used = true;
        }
    }

    public boolean isUsed() {
        return this.used;
    }
}

