/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteCatchSectionFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaughtExceptionImmediatelyRethrownInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("caught.exception.immediately.rethrown.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("caught.exception.immediately.rethrown.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiTryStatement tryStatement = (PsiTryStatement)infos[0];
        boolean removeTryCatch = tryStatement.getCatchSections().length == 1 && tryStatement.getFinallyBlock() == null && tryStatement.getResourceList() == null;
        return new DeleteCatchSectionFix(removeTryCatch);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CaughtExceptionImmediatelyRethrownVisitor();
    }

    private static class CaughtExceptionImmediatelyRethrownVisitor
    extends BaseInspectionVisitor {
        private CaughtExceptionImmediatelyRethrownVisitor() {
        }

        public void visitThrowStatement(PsiThrowStatement statement2) {
            super.visitThrowStatement(statement2);
            PsiExpression expression2 = ParenthesesUtils.stripParentheses(statement2.getException());
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement2, PsiStatement.class);
            if (previousStatement != null) {
                return;
            }
            PsiElement parent = statement2.getParent();
            if (parent instanceof PsiStatement) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)target;
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (!(declarationScope instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)declarationScope;
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiCodeBlock.class);
            if (block == null) {
                return;
            }
            PsiElement blockParent = block.getParent();
            if (blockParent != catchSection) {
                return;
            }
            if (CaughtExceptionImmediatelyRethrownVisitor.isSuperClassExceptionCaughtLater((PsiVariable)parameter, catchSection)) {
                return;
            }
            Query query = ReferencesSearch.search((PsiElement)parameter);
            for (PsiReference reference : query) {
                PsiElement element = reference.getElement();
                if (element == expression2) continue;
                return;
            }
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            this.registerVariableError((PsiVariable)parameter, tryStatement);
        }

        private static boolean isSuperClassExceptionCaughtLater(PsiVariable parameter, PsiCatchSection catchSection) {
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            PsiCatchSection[] catchSections = tryStatement.getCatchSections();
            for (int index = 0; catchSections[index] != catchSection && index < catchSections.length; ++index) {
            }
            PsiType type2 = parameter.getType();
            THashSet parameterClasses = new THashSet();
            CaughtExceptionImmediatelyRethrownVisitor.processExceptionClasses(type2, (Processor<PsiClass>)((Processor)arg_0 -> CaughtExceptionImmediatelyRethrownVisitor.lambda$isSuperClassExceptionCaughtLater$0((Set)parameterClasses, arg_0)));
            if (parameterClasses.isEmpty()) {
                return false;
            }
            Ref superClassExceptionType = new Ref((Object)Boolean.FALSE);
            for (int i2 = index; i2 < catchSections.length; ++i2) {
                PsiCatchSection nextCatchSection = catchSections[i2];
                PsiParameter nextParameter = nextCatchSection.getParameter();
                if (nextParameter == null) continue;
                PsiType nextType = nextParameter.getType();
                CaughtExceptionImmediatelyRethrownVisitor.processExceptionClasses(nextType, (Processor<PsiClass>)((Processor)arg_0 -> CaughtExceptionImmediatelyRethrownVisitor.lambda$isSuperClassExceptionCaughtLater$1((Set)parameterClasses, superClassExceptionType, arg_0)));
                if (!((Boolean)superClassExceptionType.get()).booleanValue()) continue;
                return true;
            }
            return false;
        }

        private static void processExceptionClasses(PsiType type2, Processor<PsiClass> processor2) {
            if (type2 instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)type2;
                PsiClass aClass = classType.resolve();
                if (aClass != null) {
                    processor2.process((Object)aClass);
                }
            } else if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    PsiClassType classType;
                    PsiClass aClass;
                    if (!(disjunction instanceof PsiClassType) || (aClass = (classType = (PsiClassType)disjunction).resolve()) == null) continue;
                    processor2.process((Object)aClass);
                }
            }
        }

        private static /* synthetic */ boolean lambda$isSuperClassExceptionCaughtLater$1(Set parameterClasses, Ref superClassExceptionType, PsiClass aClass) {
            for (PsiClass parameterClass : parameterClasses) {
                if (!parameterClass.isInheritor(aClass, true)) continue;
                superClassExceptionType.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        }

        private static /* synthetic */ boolean lambda$isSuperClassExceptionCaughtLater$0(Set parameterClasses, PsiClass aClass) {
            parameterClasses.add(aClass);
            return true;
        }
    }
}

