/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyCatchBlockInspectionBase
extends BaseInspection {
    public boolean m_includeComments = true;
    public boolean m_ignoreTestCases = true;
    public boolean m_ignoreIgnoreParameter = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("empty.catch.block.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("empty.catch.block.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.comments.option", new Object[0]), "m_includeComments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.ignore.ignore.option", new Object[0]), "m_ignoreIgnoreParameter");
        return optionsPanel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EmptyCatchBlockFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyCatchBlockVisitor();
    }

    private class EmptyCatchBlockVisitor
    extends BaseInspectionVisitor {
        private EmptyCatchBlockVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement2) {
            PsiCatchSection[] catchSections;
            super.visitTryStatement(statement2);
            for (PsiCatchSection section : catchSections = statement2.getCatchSections()) {
                this.checkCatchSection(section);
            }
        }

        private void checkCatchSection(PsiCatchSection section) {
            PsiCodeBlock block = section.getCatchBlock();
            if (block == null || !this.isEmpty((PsiElement)block)) {
                return;
            }
            PsiParameter parameter = section.getParameter();
            if (parameter == null) {
                return;
            }
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            String parameterName = parameter.getName();
            if (EmptyCatchBlockInspectionBase.this.m_ignoreIgnoreParameter && PsiUtil.isIgnoredName((String)parameterName)) {
                return;
            }
            PsiElement catchToken = section.getFirstChild();
            if (catchToken == null) {
                return;
            }
            this.registerError(catchToken, catchToken);
        }

        private boolean isEmpty(PsiElement element) {
            if (!EmptyCatchBlockInspectionBase.this.m_includeComments && element instanceof PsiComment) {
                return true;
            }
            if (element instanceof PsiEmptyStatement) {
                return !EmptyCatchBlockInspectionBase.this.m_includeComments || PsiTreeUtil.getChildOfType((PsiElement)element, PsiComment.class) == null;
            }
            if (element instanceof PsiWhiteSpace) {
                return true;
            }
            if (element instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)element;
                return this.isEmpty((PsiElement)block.getCodeBlock());
            }
            if (element instanceof PsiCodeBlock) {
                PsiCodeBlock codeBlock = (PsiCodeBlock)element;
                PsiElement lastBodyElement = codeBlock.getLastBodyElement();
                for (PsiElement bodyElement = codeBlock.getFirstBodyElement(); bodyElement != null; bodyElement = bodyElement.getNextSibling()) {
                    if (!this.isEmpty(bodyElement)) {
                        return false;
                    }
                    if (bodyElement == lastBodyElement) break;
                }
                return true;
            }
            return false;
        }
    }

    private static class EmptyCatchBlockFix
    extends InspectionGadgetsFix {
        private EmptyCatchBlockFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("rename.catch.parameter.to.ignored", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)parent;
            PsiParameter parameter = catchSection.getParameter();
            if (parameter == null) {
                return;
            }
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            PsiIdentifier newIdentifier = factory.createIdentifier("ignored");
            identifier.replace((PsiElement)newIdentifier);
        }
    }
}

