/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NewExceptionWithoutArgumentsInspection
extends BaseInspection {
    @Deprecated
    public boolean ignoreWithoutParameters;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("new.exception.without.arguments.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("new.exception.without.arguments.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NewExceptionWithoutArgumentsVisitor();
    }

    private class NewExceptionWithoutArgumentsVisitor
    extends BaseInspectionVisitor {
        private NewExceptionWithoutArgumentsVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] expressions2 = argumentList.getExpressions();
            if (expressions2.length != 0) {
                return;
            }
            PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
            if (classReference2 == null) {
                return;
            }
            PsiElement target = classReference2.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception")) {
                return;
            }
            if (this.hasAccessibleConstructorWithParameters(aClass, (PsiElement)expression2)) {
                this.registerNewExpressionError(expression2, new Object[0]);
            }
        }

        private boolean hasAccessibleConstructorWithParameters(PsiClass aClass, PsiElement context) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                PsiResolveHelper resolveHelper;
                PsiParameterList parameterList = constructor.getParameterList();
                int count = parameterList.getParametersCount();
                if (count <= 0 || !(resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper()).isAccessible((PsiMember)constructor, context, aClass)) continue;
                return true;
            }
            return false;
        }
    }
}

