/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NullThrownInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("null.thrown.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("null.thrown.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ThrowNullFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowNullVisitor();
    }

    private static class ThrowNullVisitor
    extends BaseInspectionVisitor {
        private ThrowNullVisitor() {
        }

        public void visitThrowStatement(PsiThrowStatement statement2) {
            super.visitThrowStatement(statement2);
            PsiExpression exception = ParenthesesUtils.stripParentheses(statement2.getException());
            if (!(exception instanceof PsiLiteralExpression)) {
                return;
            }
            PsiType type2 = exception.getType();
            if (!PsiType.NULL.equals((Object)type2)) {
                return;
            }
            this.registerError((PsiElement)exception, new Object[0]);
        }
    }

    private static class ThrowNullFix
    extends InspectionGadgetsFix {
        private ThrowNullFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("null.thrown.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiExpression newExpression = factory.createExpressionFromText("new java.lang.NullPointerException()", element);
            element.replace((PsiElement)newExpression);
        }
    }
}

