/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class ReturnFromFinallyBlockInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ReturnInsideFinallyBlock";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("return.from.finally.block.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("return.from.finally.block.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnFromFinallyBlockVisitor();
    }

    private static class ReturnFromFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private ReturnFromFinallyBlockVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement2) {
            super.visitReturnStatement(statement2);
            if (!ControlFlowUtils.isInFinallyBlock((PsiElement)statement2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }
    }
}

