/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryInitCauseInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.initcause.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.initcause.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryInitCauseVisitor();
    }

    @Nullable
    static PsiNewExpression findNewExpression(PsiExpression expression2) {
        if (expression2 instanceof PsiNewExpression) {
            return (PsiNewExpression)expression2;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiExpression definition = DeclarationSearchUtils.findDefinition(referenceExpression, null);
            if (!(definition instanceof PsiNewExpression)) {
                return null;
            }
            return (PsiNewExpression)definition;
        }
        return null;
    }

    private static class UnnecessaryInitCauseVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryInitCauseVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"initCause".equals(name)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression argument = ExpressionUtils.getOnlyExpressionInList(argumentList);
            if (!TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Throwable")) {
                return;
            }
            PsiMethod method2 = expression2.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null || !"java.lang.Throwable".equals(aClass.getQualifiedName())) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            PsiNewExpression newExpression = UnnecessaryInitCauseInspectionBase.findNewExpression(qualifier);
            if (!UnnecessaryInitCauseVisitor.isCauseConstructorAvailable(newExpression) || !UnnecessaryInitCauseVisitor.canExpressionBeMovedBackwards(argument, (PsiExpression)newExpression)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean canExpressionBeMovedBackwards(final PsiExpression cause, PsiExpression newLocation) {
            if (cause == null || newLocation == null) {
                return false;
            }
            assert (cause.getTextOffset() > newLocation.getTextOffset());
            final PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)cause, PsiCodeBlock.class);
            PsiCodeBlock newBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)newLocation, PsiCodeBlock.class);
            if (block == null || newBlock == null || !PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)newBlock, (boolean)false)) {
                return false;
            }
            final int offset = newLocation.getTextOffset();
            final Ref result2 = new Ref((Object)Boolean.TRUE);
            cause.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    PsiElement[] defs;
                    if (!((Boolean)result2.get()).booleanValue()) {
                        return;
                    }
                    super.visitReferenceExpression(expression2);
                    PsiElement target = expression2.resolve();
                    if (!(target instanceof PsiVariable)) {
                        return;
                    }
                    for (PsiElement def : defs = DefUseUtil.getDefs(block, (PsiVariable)target, (PsiElement)cause)) {
                        if (def.getTextOffset() <= offset) continue;
                        result2.set((Object)Boolean.FALSE);
                    }
                }
            });
            return (Boolean)result2.get();
        }

        public static boolean isCauseConstructorAvailable(PsiNewExpression newExpression) {
            if (newExpression == null) {
                return false;
            }
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor == null) {
                return false;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (aClass == null) {
                return false;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            block0: for (PsiMethod constructor1 : aClass.getConstructors()) {
                PsiParameterList parameterList = constructor1.getParameterList();
                if (parameterList.getParametersCount() != arguments.length + 1) continue;
                PsiParameter[] parameters2 = parameterList.getParameters();
                for (int i2 = 0; i2 < arguments.length; ++i2) {
                    PsiExpression argument = arguments[i2];
                    PsiParameter parameter = parameters2[i2];
                    PsiType type2 = argument.getType();
                    if (type2 == null || !parameter.getType().isAssignableFrom(type2)) continue block0;
                }
                PsiParameter lastParameter = parameters2[parameters2.length - 1];
                PsiType type3 = lastParameter.getType();
                if (!InheritanceUtil.isInheritor((PsiType)type3, (String)"java.lang.Throwable")) continue;
                return true;
            }
            return false;
        }
    }
}

