/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FinalizeInspection
extends BaseInspection {
    public boolean ignoreTrivialFinalizers = true;

    @NotNull
    public String getID() {
        return "FinalizeDeclaration";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("finalize.declaration.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("finalize.declaration.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.trivial.finalizers.option", new Object[0]), (InspectionProfileEntry)this, "ignoreTrivialFinalizers");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinalizeDeclaredVisitor();
    }

    private class FinalizeDeclaredVisitor
    extends BaseInspectionVisitor {
        private FinalizeDeclaredVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (!MethodUtils.isFinalize(method2)) {
                return;
            }
            if (FinalizeInspection.this.ignoreTrivialFinalizers && MethodUtils.isTrivial(method2, false)) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

