/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class FinalizeNotProtectedInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("finalize.not.declared.protected.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("finalize.not.declared.protected.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinalizeDeclaredProtectedVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ProtectedFinalizeFix();
    }

    private static class FinalizeDeclaredProtectedVisitor
    extends BaseInspectionVisitor {
        private FinalizeDeclaredProtectedVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (!MethodUtils.isFinalize(method2)) {
                return;
            }
            if (method2.hasModifierProperty("protected")) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null || aClass.isInterface()) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }

    private static class ProtectedFinalizeFix
    extends InspectionGadgetsFix {
        private ProtectedFinalizeFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("make.protected.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method2 = (PsiMethod)methodName.getParent();
            assert (method2 != null);
            PsiModifierList modifiers = method2.getModifierList();
            modifiers.setModifierProperty("public", false);
            modifiers.setModifierProperty("private", false);
            modifiers.setModifierProperty("protected", true);
        }
    }
}

