/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import org.jetbrains.annotations.NotNull;

public class DeleteCatchSectionFix
extends InspectionGadgetsFix {
    private final boolean removeTryCatch;

    public DeleteCatchSectionFix(boolean removeTryCatch) {
        this.removeTryCatch = removeTryCatch;
    }

    @NotNull
    public String getName() {
        if (this.removeTryCatch) {
            return InspectionGadgetsBundle.message("remove.try.catch.quickfix", new Object[0]);
        }
        return InspectionGadgetsBundle.message("delete.catch.section.quickfix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return "Delete catch statement";
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiParameter)) {
            return;
        }
        PsiParameter parameter = (PsiParameter)parent;
        PsiElement grandParent = parameter.getParent();
        if (!(grandParent instanceof PsiCatchSection)) {
            return;
        }
        PsiCatchSection catchSection = (PsiCatchSection)grandParent;
        PsiTryStatement tryStatement = catchSection.getTryStatement();
        if (this.removeTryCatch) {
            boolean keepBlock;
            PsiCodeBlock codeBlock = tryStatement.getTryBlock();
            if (codeBlock == null) {
                return;
            }
            PsiElement containingElement = tryStatement.getParent();
            if (containingElement instanceof PsiCodeBlock) {
                PsiCodeBlock parentBlock = (PsiCodeBlock)containingElement;
                keepBlock = DeclarationSearchUtils.containsConflictingDeclarations(codeBlock, parentBlock);
            } else {
                keepBlock = true;
            }
            if (keepBlock) {
                tryStatement.replace((PsiElement)codeBlock);
            } else {
                PsiElement firstBodyElement = codeBlock.getFirstBodyElement();
                PsiElement lastBodyElement = codeBlock.getLastBodyElement();
                if (firstBodyElement != null && lastBodyElement != null) {
                    containingElement.addRangeBefore(firstBodyElement, lastBodyElement, (PsiElement)tryStatement);
                }
                tryStatement.delete();
            }
        } else {
            catchSection.delete();
        }
    }
}

