/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.fixes.MemberSignature;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SerialVersionUIDBuilder
extends JavaRecursiveElementVisitor {
    @NonNls
    private static final String ACCESS_METHOD_NAME_PREFIX = "access$";
    private final PsiClass clazz;
    private int index = -1;
    private final Set<MemberSignature> nonPrivateConstructors;
    private final Set<MemberSignature> nonPrivateMethods;
    private final Set<MemberSignature> nonPrivateFields;
    private final List<MemberSignature> staticInitializers;
    private boolean assertStatement = false;
    private final Map<PsiElement, String> memberMap = new HashMap<PsiElement, String>();
    private static final Comparator<PsiClass> INTERFACE_COMPARATOR = (object1, object2) -> {
        if (object1 == null && object2 == null) {
            return 0;
        }
        if (object1 == null) {
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        String name1 = object1.getQualifiedName();
        String name2 = object2.getQualifiedName();
        if (name1 == null && name2 == null) {
            return 0;
        }
        if (name1 == null) {
            return 1;
        }
        if (name2 == null) {
            return -1;
        }
        return name1.compareTo(name2);
    };

    private SerialVersionUIDBuilder(PsiClass clazz) {
        MemberSignature initializerSignature;
        PsiField[] fields;
        PsiMethod[] methods;
        this.clazz = clazz;
        this.nonPrivateMethods = new HashSet<MemberSignature>();
        for (PsiMethod method2 : methods = clazz.getMethods()) {
            if (method2.isConstructor() || method2.hasModifierProperty("private")) continue;
            MemberSignature methodSignature = new MemberSignature(method2);
            this.nonPrivateMethods.add(methodSignature);
            SuperMethodsSearch.search((PsiMethod)method2, null, (boolean)true, (boolean)false).forEach(method1 -> {
                MemberSignature superSignature = new MemberSignature(methodSignature.getName(), methodSignature.getModifiers(), MemberSignature.createMethodSignature(method1.getMethod()));
                this.nonPrivateMethods.add(superSignature);
                return true;
            });
        }
        this.nonPrivateFields = new HashSet<MemberSignature>();
        for (PsiField field : fields = clazz.getFields()) {
            if (field.hasModifierProperty("private") && (field.hasModifierProperty("static") || field.hasModifierProperty("transient"))) continue;
            MemberSignature fieldSignature = new MemberSignature(field);
            this.nonPrivateFields.add(fieldSignature);
        }
        this.staticInitializers = new ArrayList<MemberSignature>(1);
        PsiClassInitializer[] initializers = clazz.getInitializers();
        if (initializers.length > 0) {
            for (PsiClassInitializer initializer : initializers) {
                PsiModifierList modifierList = initializer.getModifierList();
                if (modifierList == null || !modifierList.hasModifierProperty("static")) continue;
                initializerSignature = MemberSignature.getStaticInitializerMemberSignature();
                this.staticInitializers.add(initializerSignature);
                break;
            }
        }
        if (this.staticInitializers.isEmpty()) {
            PsiField[] psiFields;
            for (PsiField field : psiFields = clazz.getFields()) {
                if (!SerialVersionUIDBuilder.hasStaticInitializer(field)) continue;
                initializerSignature = MemberSignature.getStaticInitializerMemberSignature();
                this.staticInitializers.add(initializerSignature);
                break;
            }
        }
        PsiMethod[] constructors = clazz.getConstructors();
        this.nonPrivateConstructors = new HashSet<MemberSignature>(constructors.length);
        if (constructors.length == 0 && !clazz.isInterface()) {
            MemberSignature constructorSignature = clazz.hasModifierProperty("public") ? MemberSignature.getPublicConstructor() : MemberSignature.getPackagePrivateConstructor();
            this.nonPrivateConstructors.add(constructorSignature);
        }
        for (PsiMethod constructor : constructors) {
            if (constructor.hasModifierProperty("private")) continue;
            MemberSignature constructorSignature = new MemberSignature(constructor);
            this.nonPrivateConstructors.add(constructorSignature);
        }
    }

    public static long computeDefaultSUID(PsiClass psiClass) {
        Project project2 = psiClass.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass serializable = psiFacade.findClass("java.io.Serializable", scope);
        if (serializable == null) {
            return -1L;
        }
        boolean isSerializable = psiClass.isInheritor(serializable, true);
        if (!isSerializable) {
            return 0L;
        }
        SerialVersionUIDBuilder serialVersionUIDBuilder = new SerialVersionUIDBuilder(psiClass);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            String className = PsiFormatUtil.getExternalName((PsiModifierListOwner)psiClass);
            dataOutputStream.writeUTF(className);
            PsiModifierList classModifierList = psiClass.getModifierList();
            int classModifiers = classModifierList != null ? MemberSignature.calculateModifierBitmap(classModifierList) : 0;
            MemberSignature[] methodSignatures = serialVersionUIDBuilder.getNonPrivateMethodSignatures();
            if (psiClass.isInterface()) {
                classModifiers |= 0x200;
                if (methodSignatures.length == 0) {
                    classModifiers &= 0xFFFFFBFF;
                }
            }
            dataOutputStream.writeInt(classModifiers);
            PsiClass[] interfaces = psiClass.getInterfaces();
            Arrays.sort(interfaces, INTERFACE_COMPARATOR);
            for (PsiClass aInterfaces : interfaces) {
                String name = aInterfaces.getQualifiedName();
                dataOutputStream.writeUTF(name);
            }
            MemberSignature[] fields = serialVersionUIDBuilder.getNonPrivateFields();
            SerialVersionUIDBuilder.writeSignatures(fields, dataOutputStream);
            MemberSignature[] staticInitializers = serialVersionUIDBuilder.getStaticInitializers();
            SerialVersionUIDBuilder.writeSignatures(staticInitializers, dataOutputStream);
            MemberSignature[] constructors = serialVersionUIDBuilder.getNonPrivateConstructors();
            SerialVersionUIDBuilder.writeSignatures(constructors, dataOutputStream);
            SerialVersionUIDBuilder.writeSignatures(methodSignatures, dataOutputStream);
            dataOutputStream.flush();
            String algorithm = "SHA";
            MessageDigest digest = MessageDigest.getInstance("SHA");
            byte[] digestBytes = digest.digest(byteArrayOutputStream.toByteArray());
            long serialVersionUID = 0L;
            for (int i2 = Math.min(digestBytes.length, 8) - 1; i2 >= 0; --i2) {
                serialVersionUID = serialVersionUID << 8 | (long)(digestBytes[i2] & 0xFF);
            }
            return serialVersionUID;
        }
        catch (IOException exception) {
            InternalError internalError = new InternalError(exception.getMessage());
            internalError.initCause(exception);
            throw internalError;
        }
        catch (NoSuchAlgorithmException exception) {
            SecurityException securityException = new SecurityException(exception.getMessage());
            securityException.initCause(exception);
            throw securityException;
        }
    }

    private static void writeSignatures(MemberSignature[] signatures, DataOutputStream dataOutputStream) throws IOException {
        Arrays.sort(signatures);
        for (MemberSignature field : signatures) {
            dataOutputStream.writeUTF(field.getName());
            dataOutputStream.writeInt(field.getModifiers());
            dataOutputStream.writeUTF(field.getSignature());
        }
    }

    private String getAccessMethodIndex(PsiElement element) {
        String cache2 = this.memberMap.get(element);
        if (cache2 == null) {
            cache2 = String.valueOf(this.index);
            ++this.index;
            this.memberMap.put(element, cache2);
        }
        return cache2;
    }

    public MemberSignature[] getNonPrivateConstructors() {
        this.init();
        return this.nonPrivateConstructors.toArray(new MemberSignature[this.nonPrivateConstructors.size()]);
    }

    public MemberSignature[] getNonPrivateFields() {
        this.init();
        return this.nonPrivateFields.toArray(new MemberSignature[this.nonPrivateFields.size()]);
    }

    public MemberSignature[] getNonPrivateMethodSignatures() {
        this.init();
        return this.nonPrivateMethods.toArray(new MemberSignature[this.nonPrivateMethods.size()]);
    }

    public MemberSignature[] getStaticInitializers() {
        this.init();
        return this.staticInitializers.toArray(new MemberSignature[this.staticInitializers.size()]);
    }

    private static boolean hasStaticInitializer(PsiField field) {
        if (field.hasModifierProperty("static")) {
            PsiExpression initializer = field.getInitializer();
            if (initializer == null) {
                return false;
            }
            PsiType fieldType = field.getType();
            PsiClassType stringType = TypeUtils.getStringType((PsiElement)field);
            if (field.hasModifierProperty("final") && (fieldType instanceof PsiPrimitiveType || fieldType.equals(stringType))) {
                return !PsiUtil.isConstantExpression((PsiExpression)initializer);
            }
            return true;
        }
        return false;
    }

    private void init() {
        if (this.index < 0) {
            this.index = 0;
            this.clazz.acceptChildren((PsiElementVisitor)this);
        }
    }

    public void visitAssertStatement(PsiAssertStatement statement2) {
        super.visitAssertStatement(statement2);
        if (this.assertStatement) {
            return;
        }
        MemberSignature memberSignature = MemberSignature.getAssertionsDisabledFieldMemberSignature();
        this.nonPrivateFields.add(memberSignature);
        if (this.staticInitializers.isEmpty()) {
            MemberSignature initializerSignature = MemberSignature.getStaticInitializerMemberSignature();
            this.staticInitializers.add(initializerSignature);
        }
        this.assertStatement = true;
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiExpression[] expressions2;
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        for (PsiExpression expression2 : expressions2 = argumentList.getExpressions()) {
            expression2.accept((PsiElementVisitor)this);
        }
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        methodExpression.accept((PsiElementVisitor)this);
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        super.visitReferenceElement(reference);
        PsiClass parentClass = ClassUtils.getContainingClass((PsiElement)reference);
        if (reference.getParent() instanceof PsiTypeElement) {
            return;
        }
        PsiElement element = reference.resolve();
        if (!(element instanceof PsiClass)) {
            return;
        }
        PsiClass elementParentClass = ClassUtils.getContainingClass(element);
        if (elementParentClass == null || !elementParentClass.equals(this.clazz) || element.equals(parentClass)) {
            return;
        }
        PsiClass innerClass = (PsiClass)element;
        if (!innerClass.hasModifierProperty("private")) {
            return;
        }
        PsiMethod[] constructors = innerClass.getConstructors();
        if (constructors.length == 0) {
            this.getAccessMethodIndex((PsiElement)innerClass);
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
        PsiMethod method2;
        super.visitReferenceExpression(expression2);
        PsiElement element = expression2.resolve();
        PsiClass elementParentClass = ClassUtils.getContainingClass(element);
        PsiClass expressionParentClass = ClassUtils.getContainingClass((PsiElement)expression2);
        if (expressionParentClass == null || expressionParentClass.equals(elementParentClass)) {
            return;
        }
        PsiClass parentOfParentClass = ClassUtils.getContainingClass((PsiElement)expressionParentClass);
        while (parentOfParentClass != null && !parentOfParentClass.equals(this.clazz)) {
            if (!(expressionParentClass instanceof PsiAnonymousClass)) {
                this.getAccessMethodIndex((PsiElement)expressionParentClass);
            }
            this.getAccessMethodIndex((PsiElement)parentOfParentClass);
            parentOfParentClass = ClassUtils.getContainingClass((PsiElement)parentOfParentClass);
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("private")) {
                IElementType tokenType;
                boolean isStatic = false;
                PsiType type2 = field.getType();
                if (field.hasModifierProperty("static")) {
                    PsiExpression initializer;
                    if (field.hasModifierProperty("final") && type2 instanceof PsiPrimitiveType && PsiUtil.isConstantExpression((PsiExpression)(initializer = field.getInitializer()))) {
                        return;
                    }
                    isStatic = true;
                }
                String returnTypeSignature = MemberSignature.createTypeSignature(type2).replace('/', '.');
                String className = this.clazz.getQualifiedName();
                StringBuilder signatureBuffer = new StringBuilder("(");
                if (!isStatic) {
                    signatureBuffer.append('L').append(className).append(';');
                }
                String accessMethodIndex = this.getAccessMethodIndex((PsiElement)field);
                if (!field.getContainingClass().equals(this.clazz)) {
                    return;
                }
                String name = null;
                PsiElement parent = expression2.getParent();
                if (parent instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                    if (assignment.getLExpression().equals(expression2)) {
                        name = ACCESS_METHOD_NAME_PREFIX + accessMethodIndex + "02";
                        signatureBuffer.append(returnTypeSignature);
                    }
                } else if (parent instanceof PsiPostfixExpression) {
                    PsiPostfixExpression postfixExpression = (PsiPostfixExpression)parent;
                    tokenType = postfixExpression.getOperationTokenType();
                    if (tokenType.equals(JavaTokenType.PLUSPLUS)) {
                        name = ACCESS_METHOD_NAME_PREFIX + accessMethodIndex + "08";
                    } else if (tokenType.equals(JavaTokenType.MINUSMINUS)) {
                        name = ACCESS_METHOD_NAME_PREFIX + accessMethodIndex + "10";
                    }
                } else if (parent instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
                    tokenType = prefixExpression.getOperationTokenType();
                    if (tokenType.equals(JavaTokenType.PLUSPLUS)) {
                        name = ACCESS_METHOD_NAME_PREFIX + accessMethodIndex + "04";
                    } else if (tokenType.equals(JavaTokenType.MINUSMINUS)) {
                        name = ACCESS_METHOD_NAME_PREFIX + accessMethodIndex + "06";
                    }
                }
                if (name == null) {
                    name = ACCESS_METHOD_NAME_PREFIX + accessMethodIndex + "00";
                }
                signatureBuffer.append(')').append(returnTypeSignature);
                String signature = signatureBuffer.toString();
                MemberSignature methodSignature = new MemberSignature(name, 8, signature);
                this.nonPrivateMethods.add(methodSignature);
            }
        } else if (element instanceof PsiMethod && (method2 = (PsiMethod)element).hasModifierProperty("private") && method2.getContainingClass().equals(this.clazz)) {
            String signature;
            if (method2.hasModifierProperty("static")) {
                signature = MemberSignature.createMethodSignature(method2).replace('/', '.');
            } else {
                PsiParameter[] parameters2;
                String returnTypeSignature = MemberSignature.createTypeSignature(method2.getReturnType()).replace('/', '.');
                StringBuilder signatureBuffer = new StringBuilder();
                signatureBuffer.append("(L");
                signatureBuffer.append(this.clazz.getQualifiedName()).append(';');
                for (PsiParameter parameter : parameters2 = method2.getParameterList().getParameters()) {
                    PsiType type3 = parameter.getType();
                    String typeSignature = MemberSignature.createTypeSignature(type3).replace('/', '.');
                    signatureBuffer.append(typeSignature);
                }
                signatureBuffer.append(')');
                signatureBuffer.append(returnTypeSignature);
                signature = signatureBuffer.toString();
            }
            String accessMethodIndex = this.getAccessMethodIndex((PsiElement)method2);
            MemberSignature methodSignature = new MemberSignature(ACCESS_METHOD_NAME_PREFIX + accessMethodIndex + "00", 8, signature);
            this.nonPrivateMethods.add(methodSignature);
        }
    }
}

