/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteImportFix;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

public class JavaLangImportInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("java.lang.import.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("java.lang.import.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteImportFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JavaLangImportVisitor();
    }

    private static class JavaLangImportVisitor
    extends BaseInspectionVisitor {
        private JavaLangImportVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiImportStatement[] importStatements;
            if (!(aClass.getParent() instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file2 = (PsiJavaFile)aClass.getContainingFile();
            if (!file2.getClasses()[0].equals(aClass)) {
                return;
            }
            PsiImportList importList = file2.getImportList();
            if (importList == null) {
                return;
            }
            for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
                this.checkImportStatement(importStatement, file2);
            }
        }

        private void checkImportStatement(PsiImportStatement importStatement, PsiJavaFile file2) {
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            if (reference == null) {
                return;
            }
            String text = importStatement.getQualifiedName();
            if (text == null) {
                return;
            }
            if (importStatement.isOnDemand()) {
                if ("java.lang".equals(text)) {
                    this.registerError((PsiElement)importStatement, new Object[0]);
                }
            } else {
                int classNameIndex = text.lastIndexOf(46);
                if (classNameIndex < 0) {
                    return;
                }
                String parentName = text.substring(0, classNameIndex);
                if (!"java.lang".equals(parentName)) {
                    return;
                }
                if (ImportUtils.hasOnDemandImportConflict(text, (PsiElement)file2)) {
                    return;
                }
                this.registerError((PsiElement)importStatement, new Object[0]);
            }
        }
    }
}

