/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AbstractClassWithoutAbstractMethodsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("abstract.class.without.abstract.methods.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("abstract.class.without.abstract.methods.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractClassWithoutAbstractMethodsVisitor();
    }

    private static class AbstractClassWithoutAbstractMethodsVisitor
    extends BaseInspectionVisitor {
        private AbstractClassWithoutAbstractMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (AbstractClassWithoutAbstractMethodsVisitor.hasAbstractMethods(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static boolean hasAbstractMethods(PsiClass aClass) {
            PsiMethod[] allMethods;
            PsiMethod[] methods = aClass.getMethods();
            Set<PsiMethod> overriddenMethods = AbstractClassWithoutAbstractMethodsVisitor.calculateOverriddenMethods(methods);
            for (PsiMethod method2 : allMethods = aClass.getAllMethods()) {
                if (!method2.hasModifierProperty("abstract") || overriddenMethods.contains(method2)) continue;
                return true;
            }
            return false;
        }

        private static Set<PsiMethod> calculateOverriddenMethods(PsiMethod[] methods) {
            HashSet<PsiMethod> overriddenMethods = new HashSet<PsiMethod>(methods.length);
            for (PsiMethod method2 : methods) {
                AbstractClassWithoutAbstractMethodsVisitor.calculateOverriddenMethods(method2, overriddenMethods);
            }
            return overriddenMethods;
        }

        private static void calculateOverriddenMethods(PsiMethod method2, Set<PsiMethod> overriddenMethods) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = method2.findSuperMethods()) {
                overriddenMethods.add(superMethod);
            }
        }
    }
}

