/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class AbstractMethodOverridesAbstractMethodInspection
extends BaseInspection {
    public boolean ignoreJavaDoc = false;
    public boolean ignoreAnnotations = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.display.name", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AbstractMethodOverridesAbstractMethodFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.ignore.different.javadoc.option", new Object[0]), "ignoreJavaDoc");
        panel2.addCheckbox(InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.ignore.different.annotations.option", new Object[0]), "ignoreAnnotations");
        return panel2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodOverridesAbstractMethodVisitor();
    }

    private class AbstractMethodOverridesAbstractMethodVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodOverridesAbstractMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            PsiMethod[] superMethods;
            if (method2.isConstructor()) {
                return;
            }
            if (!this.isAbstract(method2)) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!method2.hasModifierProperty("abstract") && !containingClass.isInterface()) {
                return;
            }
            boolean overrideDefault = false;
            boolean accept = false;
            for (PsiMethod superMethod : superMethods = method2.findSuperMethods()) {
                overrideDefault |= superMethod.hasModifierProperty("default");
                if (!this.isAbstract(superMethod)) continue;
                if (overrideDefault) {
                    return;
                }
                accept |= this.methodsHaveSameReturnTypes(method2, superMethod) && this.haveSameExceptionSignatures(method2, superMethod);
                if (AbstractMethodOverridesAbstractMethodInspection.this.ignoreJavaDoc && !this.haveSameJavaDoc(method2, superMethod)) {
                    return;
                }
                if (!AbstractMethodOverridesAbstractMethodInspection.this.ignoreAnnotations || this.methodsHaveSameAnnotations(method2, superMethod)) continue;
                return;
            }
            if (accept && !overrideDefault) {
                this.registerMethodError(method2, new Object[0]);
            }
        }

        private boolean methodsHaveSameAnnotations(PsiMethod method2, PsiMethod superMethod) {
            if (!this.haveSameAnnotations((PsiModifierListOwner)method2, (PsiModifierListOwner)superMethod)) {
                return false;
            }
            PsiParameterList superParameterList = superMethod.getParameterList();
            PsiParameter[] superParameters = superParameterList.getParameters();
            PsiParameterList parameterList = method2.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            if (parameters2.length != superParameters.length) {
                return false;
            }
            int length = superParameters.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiParameter parameter = parameters2[i2];
                PsiParameter superParameter = superParameters[i2];
                if (this.haveSameAnnotations((PsiModifierListOwner)parameter, (PsiModifierListOwner)superParameter)) continue;
                return false;
            }
            return true;
        }

        private boolean haveSameAnnotations(PsiModifierListOwner owner1, PsiModifierListOwner owner2) {
            PsiModifierList modifierList = owner1.getModifierList();
            PsiModifierList superModifierList = owner2.getModifierList();
            if (superModifierList == null) {
                return modifierList == null;
            }
            if (modifierList == null) {
                return false;
            }
            PsiAnnotation[] superAnnotations = superModifierList.getAnnotations();
            PsiAnnotation[] annotations2 = modifierList.getAnnotations();
            HashSet<PsiAnnotation> annotationsSet = new HashSet<PsiAnnotation>(Arrays.asList(superAnnotations));
            for (PsiAnnotation annotation : annotations2) {
                String qualifiedName = annotation.getQualifiedName();
                if ("java.lang.Override".equals(qualifiedName) || annotationsSet.contains(annotation)) continue;
                return false;
            }
            return true;
        }

        private boolean haveSameJavaDoc(PsiMethod method2, PsiMethod superMethod) {
            PsiDocComment superDocComment = superMethod.getDocComment();
            PsiDocComment docComment = method2.getDocComment();
            return !(superDocComment == null ? docComment != null : docComment != null && !superDocComment.getText().equals(docComment.getText()));
        }

        private boolean haveSameExceptionSignatures(PsiMethod method1, PsiMethod method2) {
            PsiReferenceList list2;
            PsiClassType[] exceptions2;
            PsiReferenceList list1 = method1.getThrowsList();
            PsiClassType[] exceptions1 = list1.getReferencedTypes();
            if (exceptions1.length != (exceptions2 = (list2 = method2.getThrowsList()).getReferencedTypes()).length) {
                return false;
            }
            HashSet<PsiClassType> set1 = new HashSet<PsiClassType>(Arrays.asList(exceptions1));
            for (PsiClassType anException : exceptions2) {
                if (set1.contains(anException)) continue;
                return false;
            }
            return true;
        }

        private boolean methodsHaveSameReturnTypes(PsiMethod method1, PsiMethod method2) {
            PsiType type1 = method1.getReturnType();
            if (type1 == null) {
                return false;
            }
            PsiClass superClass = method2.getContainingClass();
            PsiClass aClass = method1.getContainingClass();
            if (aClass == null || superClass == null) {
                return false;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiType type2 = method2.getReturnType();
            return Comparing.equal((Object)type1, (Object)substitutor.substitute(type2));
        }

        private boolean isAbstract(PsiMethod method2) {
            if (method2.hasModifierProperty("abstract")) {
                return true;
            }
            PsiClass containingClass = method2.getContainingClass();
            return containingClass != null && containingClass.isInterface() && !method2.hasModifierProperty("default");
        }
    }

    private static class AbstractMethodOverridesAbstractMethodFix
    extends InspectionGadgetsFix {
        private AbstractMethodOverridesAbstractMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement method2 = methodNameIdentifier.getParent();
            assert (method2 != null);
            AbstractMethodOverridesAbstractMethodFix.deleteElement(method2);
        }
    }
}

