/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class AbstractMethodOverridesConcreteMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("abstract.method.overrides.concrete.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("abstract.method.overrides.concrete.method.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodOverridesConcreteMethodVisitor();
    }

    private static class AbstractMethodOverridesConcreteMethodVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodOverridesConcreteMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            PsiMethod[] superMethods;
            if (method2.isConstructor()) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (!method2.hasModifierProperty("abstract")) {
                return;
            }
            for (PsiMethod superMethod : superMethods = method2.findSuperMethods()) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null) continue;
                String superClassName = superClass.getQualifiedName();
                if (superClass.isInterface() || "java.lang.Object".equals(superClassName) || superMethod.hasModifierProperty("abstract")) continue;
                this.registerMethodError(method2, new Object[0]);
                return;
            }
        }
    }
}

