/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantMethodOverrideInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("redundant.method.override.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("redundant.method.override.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantMethodOverrideFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantMethodOverrideVisitor();
    }

    private static class RedundantMethodOverrideVisitor
    extends BaseInspectionVisitor {
        private RedundantMethodOverrideVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            PsiCodeBlock body2 = method2.getBody();
            if (body2 == null) {
                return;
            }
            if (method2.getNameIdentifier() == null) {
                return;
            }
            PsiMethod superMethod = MethodUtils.getSuper(method2);
            if (superMethod == null) {
                return;
            }
            if (!RedundantMethodOverrideVisitor.modifierListsAreEquivalent(method2.getModifierList(), superMethod.getModifierList())) {
                return;
            }
            PsiType superReturnType = superMethod.getReturnType();
            if (superReturnType == null || !superReturnType.equals(method2.getReturnType())) {
                return;
            }
            if (method2.hasModifierProperty("final")) {
                return;
            }
            ParameterEquivalenceChecker checker = new ParameterEquivalenceChecker(method2, superMethod);
            PsiCodeBlock superBody = superMethod.getBody();
            if (checker.codeBlocksAreEquivalent(body2, superBody) || this.isSuperCallWithSameArguments(body2, method2, superMethod)) {
                this.registerMethodError(method2, new Object[0]);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isSuperCallWithSameArguments(PsiCodeBlock body2, PsiMethod method2, PsiMethod superMethod) {
            PsiExpression expression2;
            PsiStatement[] statements = body2.getStatements();
            if (statements.length != 1) {
                return false;
            }
            PsiStatement statement2 = statements[0];
            if (PsiType.VOID.equals((Object)method2.getReturnType())) {
                if (!(statement2 instanceof PsiExpressionStatement)) return false;
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
                expression2 = expressionStatement.getExpression();
            } else {
                if (!(statement2 instanceof PsiReturnStatement)) return false;
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
                expression2 = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
            }
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            if (!MethodCallUtils.isSuperMethodCall(methodCallExpression, method2)) {
                return false;
            }
            if (!superMethod.hasModifierProperty("protected")) return RedundantMethodOverrideVisitor.areSameArguments(methodCallExpression, method2);
            PsiJavaFile file2 = (PsiJavaFile)method2.getContainingFile();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)method2.getProject()).findPackage(file2.getPackageName());
            if (aPackage == null) {
                return false;
            }
            PackageScope scope = new PackageScope(aPackage, false, false);
            if (this.isOnTheFly()) {
                PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)method2.getProject());
                PsiSearchHelper.SearchCostResult cost = searchHelper.isCheapEnoughToSearch(method2.getName(), (GlobalSearchScope)scope, null, null);
                if (cost == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                    return true;
                }
                if (cost == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return false;
                }
            }
            Query search = ReferencesSearch.search((PsiElement)method2, (SearchScope)scope);
            PsiClass containingClass = method2.getContainingClass();
            for (PsiReference reference : search) {
                if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)reference.getElement(), (boolean)true)) continue;
                return false;
            }
            return RedundantMethodOverrideVisitor.areSameArguments(methodCallExpression, method2);
        }

        private static boolean areSameArguments(PsiMethodCallExpression methodCallExpression, PsiMethod method2) {
            PsiParameter[] parameters2;
            PsiExpression[] arguments = methodCallExpression.getArgumentList().getExpressions();
            if (arguments.length != (parameters2 = method2.getParameterList().getParameters()).length) {
                return false;
            }
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                PsiExpression argument = arguments[i2];
                PsiExpression exp = PsiUtil.deparenthesizeExpression((PsiExpression)argument);
                if (!(exp instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiElement resolved = ((PsiReferenceExpression)exp).resolve();
                if (method2.getManager().areElementsEquivalent((PsiElement)parameters2[i2], resolved)) continue;
                return false;
            }
            return true;
        }

        private static boolean modifierListsAreEquivalent(@Nullable PsiModifierList list1, @Nullable PsiModifierList list2) {
            if (list1 == null) {
                return list2 == null;
            }
            if (list2 == null) {
                return false;
            }
            if (list1.hasModifierProperty("strictfp") != list2.hasModifierProperty("strictfp") || list1.hasModifierProperty("synchronized") != list2.hasModifierProperty("synchronized") || list1.hasModifierProperty("public") != list2.hasModifierProperty("public") || list1.hasModifierProperty("protected") != list2.hasModifierProperty("protected")) {
                return false;
            }
            return AnnotationUtil.equal((PsiAnnotation[])list1.getAnnotations(), (PsiAnnotation[])list2.getAnnotations());
        }

        private static class ParameterEquivalenceChecker
        extends EquivalenceChecker {
            private final PsiMethod myMethod;
            private final PsiMethod mySuperMethod;

            ParameterEquivalenceChecker(@NotNull PsiMethod method2, @NotNull PsiMethod superMethod) {
                this.myMethod = method2;
                this.mySuperMethod = superMethod;
            }

            @Override
            protected EquivalenceChecker.Decision referenceExpressionsAreEquivalentDecision(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
                if (this.areSameParameters(referenceExpression1, referenceExpression2)) {
                    return EXACTLY_MATCHES;
                }
                return super.referenceExpressionsAreEquivalentDecision(referenceExpression1, referenceExpression2);
            }

            private boolean areSameParameters(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
                int index2;
                PsiElement scope2;
                PsiElement resolved1 = referenceExpression1.resolve();
                PsiElement resolved2 = referenceExpression2.resolve();
                if (!(resolved1 instanceof PsiParameter) || !(resolved2 instanceof PsiParameter)) {
                    return false;
                }
                PsiElement scope1 = ((PsiParameter)resolved1).getDeclarationScope();
                if (scope1 == (scope2 = ((PsiParameter)resolved2).getDeclarationScope()) || scope1 != this.myMethod && scope1 != this.mySuperMethod || scope2 != this.myMethod && scope2 != this.mySuperMethod) {
                    return false;
                }
                PsiElement parent1 = resolved1.getParent();
                PsiElement parent2 = resolved2.getParent();
                if (!(parent1 instanceof PsiParameterList) || !(parent2 instanceof PsiParameterList)) {
                    return false;
                }
                int index1 = ((PsiParameterList)parent1).getParameterIndex((PsiParameter)resolved1);
                return index1 == (index2 = ((PsiParameterList)parent2).getParameterIndex((PsiParameter)resolved2));
            }
        }
    }

    private static class RedundantMethodOverrideFix
    extends InspectionGadgetsFix {
        private RedundantMethodOverrideFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("redundant.method.override.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement method2 = methodNameIdentifier.getParent();
            assert (method2 != null);
            RedundantMethodOverrideFix.deleteElement(method2);
        }
    }
}

