/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringToUpperWithoutLocaleInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "StringToUpperCaseOrToLowerCaseWithoutLocale";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("string.touppercase.tolowercase.without.locale.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("string.touppercase.tolowercase.without.locale.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)infos[0];
        PsiModifierListOwner annotatableQualifier = NonNlsUtils.getAnnotatableQualifier(methodExpression);
        if (annotatableQualifier == null) {
            return null;
        }
        return new DelegatingFix((LocalQuickFix)new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", annotatableQualifier, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringToUpperWithoutLocaleVisitor();
    }

    private static class StringToUpperWithoutLocaleVisitor
    extends BaseInspectionVisitor {
        private StringToUpperWithoutLocaleVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toUpperCase".equals(methodName) && !"toLowerCase".equals(methodName)) {
                return;
            }
            if (NonNlsUtils.isNonNlsAnnotatedUse((PsiExpression)expression2)) {
                return;
            }
            PsiMethod method2 = expression2.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (parameterList.getParametersCount() == 1) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (NonNlsUtils.isNonNlsAnnotated(qualifier)) {
                return;
            }
            this.registerMethodCallError(expression2, methodExpression);
        }
    }
}

