/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallInLoopConditionInspectionBase
extends BaseInspection {
    public boolean ignoreIterationMethods = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.call.in.loop.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.call.in.loop.condition.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore iteration method calls", (InspectionProfileEntry)this, "ignoreIterationMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCallInLoopConditionVisitor();
    }

    private class MethodCallInLoopConditionVisitor
    extends BaseInspectionVisitor {
        private MethodCallInLoopConditionVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            super.visitForStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
            super.visitDoWhileStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        private void checkForMethodCalls(PsiExpression condition2) {
            JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
                    super.visitMethodCallExpression(expression2);
                    if (MethodCallInLoopConditionInspectionBase.this.ignoreIterationMethods) {
                        PsiMethod method2 = expression2.resolveMethod();
                        if (MethodCallUtils.isCallToMethod(expression2, "java.util.Iterator", (PsiType)PsiType.BOOLEAN, "hasNext", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.util.ListIterator", (PsiType)PsiType.BOOLEAN, "hasPrevious", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.sql.ResultSet", (PsiType)PsiType.BOOLEAN, "next", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.util.Enumeration", (PsiType)PsiType.BOOLEAN, "hasMoreElements", new PsiType[0])) {
                            return;
                        }
                    }
                    MethodCallInLoopConditionVisitor.this.registerMethodCallError(expression2, new Object[0]);
                }
            };
            condition2.accept((PsiElementVisitor)visitor);
        }
    }
}

