/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.j2me.ShiftUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiplyOrDivideByPowerOfTwoInspection
extends BaseInspection {
    public boolean checkDivision = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("multiply.or.divide.by.power.of.two.display.name", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("multiply.or.divide.by.power.of.two.divide.option", new Object[0]), (InspectionProfileEntry)this, "checkDivision");
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", MultiplyOrDivideByPowerOfTwoInspection.calculateReplacementShift((PsiExpression)infos[0]));
    }

    static String calculateReplacementShift(PsiExpression expression2) {
        String operator2;
        IElementType tokenType;
        PsiExpression rhs;
        PsiExpression lhs;
        PsiAssignmentExpression exp;
        if (expression2 instanceof PsiAssignmentExpression) {
            exp = (PsiAssignmentExpression)expression2;
            lhs = exp.getLExpression();
            rhs = exp.getRExpression();
            tokenType = exp.getOperationTokenType();
            operator2 = tokenType.equals(JavaTokenType.ASTERISKEQ) ? "<<=" : ">>=";
        } else {
            exp = (PsiBinaryExpression)expression2;
            lhs = exp.getLOperand();
            rhs = exp.getROperand();
            tokenType = exp.getOperationTokenType();
            operator2 = tokenType.equals(JavaTokenType.ASTERISK) ? "<<" : ">>";
        }
        if (!(rhs instanceof PsiLiteralExpression)) {
            return null;
        }
        String lhsText = ParenthesesUtils.getPrecedence(lhs) > 7 ? '(' + lhs.getText() + ')' : lhs.getText();
        String expString = lhsText + operator2 + ShiftUtils.getLogBaseTwo((PsiLiteralExpression)rhs);
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiExpression && !(parent instanceof PsiParenthesizedExpression) && ParenthesesUtils.getPrecedence((PsiExpression)parent) < 7) {
            expString = '(' + expString + ')';
        }
        return expString;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiAssignmentExpression assignmentExpression;
        PsiBinaryExpression binaryExpression;
        IElementType operationTokenType;
        PsiExpression expression2 = (PsiExpression)infos[0];
        if (expression2 instanceof PsiBinaryExpression ? JavaTokenType.DIV.equals(operationTokenType = (binaryExpression = (PsiBinaryExpression)expression2).getOperationTokenType()) : expression2 instanceof PsiAssignmentExpression && JavaTokenType.DIVEQ.equals(operationTokenType = (assignmentExpression = (PsiAssignmentExpression)expression2).getOperationTokenType())) {
            return null;
        }
        return new MultiplyByPowerOfTwoFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantShiftVisitor();
    }

    private class ConstantShiftVisitor
    extends BaseInspectionVisitor {
        private ConstantShiftVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (!(tokenType.equals(JavaTokenType.ASTERISK) || MultiplyOrDivideByPowerOfTwoInspection.this.checkDivision && tokenType.equals(JavaTokenType.DIV))) {
                return;
            }
            if (!ShiftUtils.isPowerOfTwo(rhs)) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            if (!ClassUtils.isIntegral(type2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!(tokenType.equals(JavaTokenType.ASTERISKEQ) || MultiplyOrDivideByPowerOfTwoInspection.this.checkDivision && tokenType.equals(JavaTokenType.DIVEQ))) {
                return;
            }
            PsiExpression rhs = expression2.getRExpression();
            if (!ShiftUtils.isPowerOfTwo(rhs)) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            if (!ClassUtils.isIntegral(type2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }
    }

    private static class MultiplyByPowerOfTwoFix
    extends InspectionGadgetsFix {
        private MultiplyByPowerOfTwoFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("multiply.or.divide.by.power.of.two.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression expression2 = (PsiExpression)descriptor.getPsiElement();
            String newExpression = MultiplyOrDivideByPowerOfTwoInspection.calculateReplacementShift(expression2);
            if (newExpression != null) {
                PsiReplacementUtil.replaceExpression(expression2, newExpression);
            }
        }
    }
}

