/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateMemberAccessBetweenOuterAndInnerClassInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "SyntheticAccessorCall";
    }

    @Nullable
    public String getAlternativeID() {
        return "PrivateMemberAccessBetweenOuterAndInnerClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        return InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.problem.descriptor", aClass.getName());
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        if (infos.length == 1) {
            return new MakePackagePrivateFix(className, true);
        }
        PsiMember member = (PsiMember)infos[1];
        String memberName = member instanceof PsiMethod ? member.getName() + "()" : member.getName();
        String elementName = className + '.' + memberName;
        return new MakePackagePrivateFix(elementName, false);
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PrivateMemberAccessFromInnerClassVisitor();
    }

    private static class PrivateMemberAccessFromInnerClassVisitor
    extends BaseInspectionVisitor {
        private PrivateMemberAccessFromInnerClassVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (expression2.getType() instanceof PsiArrayType) {
                return;
            }
            PsiClass containingClass = PrivateMemberAccessFromInnerClassVisitor.getContainingContextClass((PsiElement)expression2);
            if (containingClass == null) {
                return;
            }
            JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
            if (!resolveResult.isAccessible()) {
                return;
            }
            PsiMethod constructor = (PsiMethod)resolveResult.getElement();
            if (constructor == null) {
                PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
                if (classReference2 == null) {
                    return;
                }
                PsiElement target = classReference2.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                PsiClass aClass = (PsiClass)target;
                if (!aClass.hasModifierProperty("private")) {
                    return;
                }
                if (aClass.equals(containingClass)) {
                    return;
                }
                this.registerNewExpressionError(expression2, aClass);
            } else {
                if (!constructor.hasModifierProperty("private")) {
                    return;
                }
                PsiClass aClass = constructor.getContainingClass();
                if (containingClass.equals(aClass)) {
                    return;
                }
                this.registerNewExpressionError(expression2, aClass);
            }
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement referenceNameElement = expression2.getReferenceNameElement();
            if (referenceNameElement == null) {
                return;
            }
            JavaResolveResult resolveResult = expression2.advancedResolve(false);
            if (!resolveResult.isAccessible()) {
                return;
            }
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiMethod) && !(element instanceof PsiField)) {
                return;
            }
            PsiMember member = (PsiMember)element;
            if (!member.hasModifierProperty("private")) {
                return;
            }
            Object value2 = ExpressionUtils.computeConstantExpression((PsiExpression)expression2);
            if (value2 != null) {
                return;
            }
            PsiClass containingClass = PrivateMemberAccessFromInnerClassVisitor.getContainingContextClass((PsiElement)expression2);
            if (containingClass == null) {
                return;
            }
            PsiClass memberClass = ClassUtils.getContainingClass((PsiElement)member);
            if (memberClass == null || memberClass.equals(containingClass)) {
                return;
            }
            this.registerError(referenceNameElement, memberClass, member);
        }

        @Nullable
        private static PsiClass getContainingContextClass(PsiElement element) {
            PsiAnonymousClass anonymousClass;
            PsiExpressionList arguments;
            PsiClass aClass = ClassUtils.getContainingClass(element);
            if (aClass instanceof PsiAnonymousClass && (arguments = (anonymousClass = (PsiAnonymousClass)aClass).getArgumentList()) != null && PsiTreeUtil.isAncestor((PsiElement)arguments, (PsiElement)element, (boolean)true)) {
                return ClassUtils.getContainingClass((PsiElement)aClass);
            }
            return aClass;
        }
    }

    private static class MakePackagePrivateFix
    extends InspectionGadgetsFix {
        private final String elementName;
        private final boolean constructor;

        private MakePackagePrivateFix(String elementName, boolean constructor) {
            this.elementName = elementName;
            this.constructor = constructor;
        }

        @NotNull
        public String getName() {
            if (this.constructor) {
                return InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.constructor.package.local.quickfix", this.elementName);
            }
            return InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.local.quickfix", this.elementName);
        }

        @NotNull
        public String getFamilyName() {
            return "Make package-private";
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (this.constructor) {
                MakePackagePrivateFix.makeConstructorPackageLocal(project2, element);
            } else {
                MakePackagePrivateFix.makeMemberPackageLocal(element);
            }
        }

        private static void makeMemberPackageLocal(PsiElement element) {
            PsiElement parent = element.getParent();
            PsiReferenceExpression reference = (PsiReferenceExpression)parent;
            PsiModifierListOwner member = (PsiModifierListOwner)reference.resolve();
            if (member == null) {
                return;
            }
            PsiModifierList modifiers = member.getModifierList();
            if (modifiers == null) {
                return;
            }
            modifiers.setModifierProperty("public", false);
            modifiers.setModifierProperty("protected", false);
            modifiers.setModifierProperty("private", false);
        }

        private static void makeConstructorPackageLocal(Project project2, PsiElement element) {
            PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
            if (newExpression == null) {
                return;
            }
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor != null) {
                PsiModifierList modifierList = constructor.getModifierList();
                modifierList.setModifierProperty("private", false);
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiMethod newConstructor = elementFactory.createConstructor();
            PsiModifierList modifierList = newConstructor.getModifierList();
            modifierList.setModifierProperty("packageLocal", true);
            aClass.add((PsiElement)newConstructor);
        }
    }
}

