/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class FieldHasSetterButNoGetterInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("field.has.setter.but.no.getter.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("field.has.setter.but.no.getter.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldHasSetterButNoGetterVisitor();
    }

    private static class FieldHasSetterButNoGetterVisitor
    extends BaseInspectionVisitor {
        private FieldHasSetterButNoGetterVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            String propertyName = PropertyUtil.suggestPropertyName((PsiField)field);
            boolean isStatic = field.hasModifierProperty("static");
            PsiClass containingClass = field.getContainingClass();
            PsiMethod setter = PropertyUtil.findPropertySetter((PsiClass)containingClass, (String)propertyName, (boolean)isStatic, (boolean)false);
            if (setter == null) {
                return;
            }
            PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)containingClass, (String)propertyName, (boolean)isStatic, (boolean)false);
            if (getter != null) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

