/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PropertyValueSetToItselfInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("property.value.set.to.itself.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("property.value.set.to.itself.display.name", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PropertyValueSetToItselfVisitor();
    }

    private static class PropertyValueSetToItselfVisitor
    extends BaseInspectionVisitor {
        private PropertyValueSetToItselfVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiExpressionList argumentList1 = expression2.getArgumentList();
            PsiExpression[] arguments1 = argumentList1.getExpressions();
            if (arguments1.length != 1) {
                return;
            }
            PsiExpression argument = arguments1[0];
            if (!(argument instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)argument;
            PsiExpressionList argumentList2 = methodCallExpression.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length != 0) {
                return;
            }
            PsiReferenceExpression methodExpression1 = expression2.getMethodExpression();
            PsiExpression qualifierExpression1 = ParenthesesUtils.stripParentheses(methodExpression1.getQualifierExpression());
            PsiReferenceExpression methodExpression2 = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = ParenthesesUtils.stripParentheses(methodExpression2.getQualifierExpression());
            if (qualifierExpression1 instanceof PsiReferenceExpression && qualifierExpression2 instanceof PsiReferenceExpression ? !EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(qualifierExpression1, qualifierExpression2) : qualifierExpression1 != null && !(qualifierExpression1 instanceof PsiThisExpression) && !(qualifierExpression1 instanceof PsiSuperExpression) || qualifierExpression2 != null && !(qualifierExpression2 instanceof PsiThisExpression) && !(qualifierExpression2 instanceof PsiSuperExpression)) {
                return;
            }
            PsiMethod method1 = expression2.resolveMethod();
            PsiField fieldOfSetter = PropertyUtil.getFieldOfSetter((PsiMethod)method1);
            if (fieldOfSetter == null) {
                return;
            }
            PsiMethod method2 = methodCallExpression.resolveMethod();
            PsiField fieldOfGetter = PropertyUtil.getFieldOfGetter((PsiMethod)method2);
            if (!fieldOfSetter.equals(fieldOfGetter)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

