/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousGetterSetterInspection
extends BaseInspection {
    public boolean onlyWarnWhenFieldPresent = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("suspicious.getter.setter.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return (Boolean)infos[0] != false ? InspectionGadgetsBundle.message("suspicious.setter.problem.descriptor", infos[1]) : InspectionGadgetsBundle.message("suspicious.getter.problem.descriptor", infos[1]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Only warn when field matching getter/setter name is present", (InspectionProfileEntry)this, "onlyWarnWhenFieldPresent");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousGetterSetterVisitor();
    }

    private static boolean nameStartsWith(String name, String prefix) {
        return name.startsWith(prefix) && name.length() != prefix.length() && Character.isUpperCase(name.charAt(prefix.length()));
    }

    private class SuspiciousGetterSetterVisitor
    extends BaseInspectionVisitor {
        private SuspiciousGetterSetterVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            boolean setter;
            String extractedFieldName;
            String fieldName;
            PsiField getterField;
            super.visitMethod(method2);
            String name = method2.getName();
            if (SuspiciousGetterSetterInspection.nameStartsWith(name, "get")) {
                getterField = PropertyUtil.getFieldOfGetter((PsiMethod)method2);
                if (getterField == null) {
                    return;
                }
                fieldName = getterField.getName();
                extractedFieldName = name.substring(3);
                setter = false;
            } else if (SuspiciousGetterSetterInspection.nameStartsWith(name, "is")) {
                getterField = PropertyUtil.getFieldOfGetter((PsiMethod)method2);
                if (getterField == null) {
                    return;
                }
                fieldName = getterField.getName();
                extractedFieldName = name.substring(2);
                setter = false;
            } else if (SuspiciousGetterSetterInspection.nameStartsWith(name, "set")) {
                PsiField setterField = PropertyUtil.getFieldOfSetter((PsiMethod)method2);
                if (setterField == null) {
                    return;
                }
                fieldName = setterField.getName();
                extractedFieldName = name.substring(3);
                setter = true;
            } else {
                return;
            }
            if (fieldName == null) {
                return;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)method2.getProject());
            String computedFieldName = codeStyleManager.propertyNameToVariableName(extractedFieldName, VariableKind.FIELD);
            String computedStaticFieldName = codeStyleManager.propertyNameToVariableName(extractedFieldName, VariableKind.STATIC_FINAL_FIELD);
            if (fieldName.equalsIgnoreCase(computedFieldName) || fieldName.equalsIgnoreCase(computedStaticFieldName)) {
                return;
            }
            if (SuspiciousGetterSetterInspection.this.onlyWarnWhenFieldPresent) {
                PsiClass aClass = method2.getContainingClass();
                if (aClass == null) {
                    return;
                }
                if (aClass.findFieldByName(computedFieldName, true) == null && aClass.findFieldByName(computedStaticFieldName, true) == null) {
                    return;
                }
            }
            this.registerMethodError(method2, setter, fieldName);
        }
    }
}

