/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PackageDotHtmlMayBePackageInfoInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (((Boolean)infos[1]).booleanValue()) {
            return InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.exists.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageDotHtmlMayBePackageInfoVisitor();
    }

    private static class PackageDotHtmlMayBePackageInfoVisitor
    extends BaseInspectionVisitor {
        private PackageDotHtmlMayBePackageInfoVisitor() {
        }

        public void visitFile(PsiFile file2) {
            super.visitFile(file2);
            if (!(file2 instanceof XmlFile)) {
                return;
            }
            String fileName = file2.getName();
            if (!"package.html".equals(fileName)) {
                return;
            }
            PsiDirectory directory = file2.getContainingDirectory();
            if (directory == null) {
                return;
            }
            String aPackage = PackageDotHtmlMayBePackageInfoVisitor.getPackage(directory);
            if (aPackage == null) {
                return;
            }
            boolean exists = directory.findFile("package-info.java") != null;
            this.registerError((PsiElement)file2, aPackage, exists);
        }

        public static String getPackage(@NotNull PsiDirectory directory) {
            VirtualFile virtualFile = directory.getVirtualFile();
            Project project2 = directory.getProject();
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project2);
            ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
            return fileIndex.getPackageNameByDirectory(virtualFile);
        }
    }
}

