/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class EnumAsNameInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        return "EnumAsIdentifier";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("use.enum.as.identifier.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("use.enum.as.identifier.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EnumAsNameVisitor();
    }

    private static class EnumAsNameVisitor
    extends BaseInspectionVisitor {
        private EnumAsNameVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            super.visitVariable(variable);
            String variableName = variable.getName();
            if (!"enum".equals(variableName)) {
                return;
            }
            this.registerVariableError(variable, new Object[0]);
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            super.visitMethod(method2);
            String name = method2.getName();
            if (!"enum".equals(name)) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            String name = aClass.getName();
            if (!"enum".equals(name)) {
                return;
            }
            PsiTypeParameterList params = aClass.getTypeParameterList();
            if (params != null) {
                params.accept((PsiElementVisitor)this);
            }
            this.registerClassError(aClass, new Object[0]);
        }

        public void visitTypeParameter(PsiTypeParameter parameter) {
            super.visitTypeParameter(parameter);
            String name = parameter.getName();
            if (!"enum".equals(name)) {
                return;
            }
            this.registerTypeParameterError(parameter, new Object[0]);
        }
    }
}

