/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ForeachStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("extended.for.statement.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("extended.for.statement.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ForEachFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForeachStatementVisitor();
    }

    private static class ForeachStatementVisitor
    extends BaseInspectionVisitor {
        private ForeachStatementVisitor() {
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement2) {
            super.visitForeachStatement(statement2);
            PsiExpression iteratedValue2 = statement2.getIteratedValue();
            if (iteratedValue2 == null || !InheritanceUtil.isInheritor((PsiType)iteratedValue2.getType(), (String)"java.lang.Iterable")) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }
    }

    private static class ForEachFix
    extends InspectionGadgetsFix {
        private ForEachFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("extended.for.statement.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiForeachStatement statement2 = (PsiForeachStatement)element.getParent();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            assert (statement2 != null);
            PsiExpression iteratedValue2 = statement2.getIteratedValue();
            if (iteratedValue2 == null) {
                return;
            }
            StringBuilder newStatement = new StringBuilder();
            PsiParameter iterationParameter = statement2.getIterationParameter();
            boolean generateFinalLocals = JavaCodeStyleSettingsFacade.getInstance((Project)project2).isGenerateFinalLocals();
            if (iteratedValue2.getType() instanceof PsiArrayType) {
                PsiType type2 = iterationParameter.getType();
                String index = codeStyleManager.suggestUniqueVariableName("i", (PsiElement)statement2, true);
                newStatement.append("for(int ").append(index).append(" = 0;");
                newStatement.append(index).append('<').append(iteratedValue2.getText()).append(".length;");
                newStatement.append(index).append("++)").append("{ ");
                if (generateFinalLocals) {
                    newStatement.append("final ");
                }
                newStatement.append(type2.getCanonicalText()).append(' ').append(iterationParameter.getName());
                newStatement.append(" = ").append(iteratedValue2.getText()).append('[').append(index).append("];");
            } else {
                StringBuilder methodCall = new StringBuilder();
                if (ParenthesesUtils.getPrecedence(iteratedValue2) > 1) {
                    methodCall.append('(').append(iteratedValue2.getText()).append(')');
                } else {
                    methodCall.append(iteratedValue2.getText());
                }
                methodCall.append(".iterator()");
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
                PsiExpression iteratorCall = factory.createExpressionFromText(methodCall.toString(), (PsiElement)iteratedValue2);
                PsiType variableType = GenericsUtil.getVariableTypeByExpressionType((PsiType)iteratorCall.getType());
                if (variableType == null) {
                    return;
                }
                PsiType parameterType = iterationParameter.getType();
                String typeText = parameterType.getCanonicalText();
                newStatement.append("for(").append(variableType.getCanonicalText()).append(' ');
                String iterator = codeStyleManager.suggestUniqueVariableName("iterator", (PsiElement)statement2, true);
                newStatement.append(iterator).append("=").append(iteratorCall.getText()).append(';');
                newStatement.append(iterator).append(".hasNext();){");
                if (generateFinalLocals) {
                    newStatement.append("final ");
                }
                newStatement.append(typeText).append(' ').append(iterationParameter.getName()).append(" = ").append(iterator).append(".next();");
            }
            PsiStatement body2 = statement2.getBody();
            if (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                PsiElement[] children2 = block.getChildren();
                for (int i2 = 1; i2 < children2.length - 1; ++i2) {
                    newStatement.append(children2[i2].getText());
                }
            } else {
                String bodyText = body2 == null ? "" : body2.getText();
                newStatement.append(bodyText);
            }
            newStatement.append('}');
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement2, newStatement.toString());
        }
    }
}

