/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.NotNull;

public class AssertEqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("assertequals.between.inconvertible.types.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return (String)infos[0];
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsBetweenInconvertibleTypesVisitor();
    }

    private static class AssertEqualsBetweenInconvertibleTypesVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsBetweenInconvertibleTypesVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            String compatibilityErrorMessage = AssertHint.areExpectedActualTypesCompatible(expression2, false);
            if (compatibilityErrorMessage != null) {
                this.registerMethodCallError(expression2, compatibilityErrorMessage);
            }
        }
    }
}

