/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class BeforeOrAfterIsPublicVoidNoArgInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        return "BeforeOrAfterWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("before.or.after.is.public.void.no.arg.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("before.or.after.is.public.void.no.arg.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BeforeOrAfterIsPublicVoidNoArgVisitor();
    }

    private static class BeforeOrAfterIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private BeforeOrAfterIsPublicVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (!TestUtils.isJUnit4BeforeOrAfterMethod(method2)) {
                return;
            }
            PsiType returnType = method2.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass targetClass = method2.getContainingClass();
            if (targetClass == null) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (parameterList.getParametersCount() != 0 || !returnType.equals(PsiType.VOID) || !method2.hasModifierProperty("public") || method2.hasModifierProperty("static")) {
                this.registerMethodError(method2, method2);
            }
        }
    }
}

