/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExpectedExceptionNeverThrownInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("expected.exception.never.thrown.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method2 = (PsiMethod)infos[0];
        return InspectionGadgetsBundle.message("expected.exception.never.thrown.problem.descriptor", method2.getName());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExpectedExceptionNeverThrownVisitor();
    }

    private static class ExpectedExceptionNeverThrownVisitor
    extends BaseInspectionVisitor {
        private ExpectedExceptionNeverThrownVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method2, (String[])new String[]{"org.junit.Test"});
            if (annotation == null) {
                return;
            }
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            PsiNameValuePair[] attributes = parameterList.getAttributes();
            PsiAnnotationMemberValue value2 = null;
            for (PsiNameValuePair attribute : attributes) {
                if (!"expected".equals(attribute.getName())) continue;
                value2 = attribute.getValue();
                break;
            }
            if (!(value2 instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiCodeBlock body2 = method2.getBody();
            if (body2 == null) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)value2;
            PsiTypeElement operand2 = classObjectAccessExpression.getOperand();
            PsiType type2 = operand2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Error")) {
                return;
            }
            List<PsiClassType> exceptionsThrown = ExceptionUtil.getThrownExceptions((PsiElement)body2);
            for (PsiClassType psiClassType : exceptionsThrown) {
                if (!psiClassType.isAssignableFrom((PsiType)classType)) continue;
                return;
            }
            this.registerError((PsiElement)operand2, method2);
        }
    }
}

