/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JUnit3MethodNamingConventionInspectionBase
extends ConventionInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("junit3.method.naming.convention.display.name", new Object[0]);
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("junit3.method.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "test[A-Za-z_\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JUnit3MethodNamingConventionVisitor();
    }

    private class JUnit3MethodNamingConventionVisitor
    extends BaseInspectionVisitor {
        private JUnit3MethodNamingConventionVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            if (!TestUtils.isJUnit3TestMethod(method2) || !TestUtils.isRunnable(method2)) {
                return;
            }
            PsiIdentifier nameIdentifier = method2.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            String name = method2.getName();
            if (JUnit3MethodNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            if (!this.isOnTheFly() && MethodUtils.hasSuper(method2)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method2)) {
                return;
            }
            this.registerMethodError(method2, name);
        }
    }
}

