/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit3StyleTestMethodInJUnit4ClassInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("junit3.style.test.method.in.junit4.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("junit3.style.test.method.in.junit4.class.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DelegatingFix(new AnnotateMethodFix("org.junit.Test", new String[0]){

            @Override
            public int shouldAnnotateBaseMethod(PsiMethod method2, PsiMethod superMethod, Project project2) {
                return 1;
            }
        });
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor();
    }

    public static boolean containsJUnit4Annotation(PsiElement element) {
        JUnit4AnnotationVisitor visitor = new JUnit4AnnotationVisitor();
        element.accept((PsiElementVisitor)visitor);
        return visitor.isJUnit4AnnotationFound();
    }

    private static class JUnit4AnnotationVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myJUnit4AnnotationFound = false;

        private JUnit4AnnotationVisitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.startsWith("org.junit.")) {
                return;
            }
            this.myJUnit4AnnotationFound = true;
        }

        public boolean isJUnit4AnnotationFound() {
            return this.myJUnit4AnnotationFound;
        }
    }

    private static class JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor
    extends BaseInspectionVisitor {
        private JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            String name = method2.getName();
            if (!name.startsWith("test")) {
                return;
            }
            if (!TestUtils.isRunnable(method2)) {
                return;
            }
            if (TestUtils.isAnnotatedTestMethod(method2)) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (TestUtils.isJUnitTestClass(containingClass)) {
                return;
            }
            if (!JUnit3StyleTestMethodInJUnit4ClassInspection.containsJUnit4Annotation((PsiElement)containingClass)) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

